/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.AELog;
import appeng.core.worlddata.AESavedData;
import appeng.core.worlddata.IGridStorageSaveData;
import appeng.me.GridStorage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public final class GridStorageSaveData
extends AESavedData
implements IGridStorageSaveData {
    public static final String NAME = "ae2_storage";
    private static final String TAG_NEXT_ID = "nextId";
    public static final String TAG_STORAGE = "storage";
    private final Map<Long, GridStorage> storage = new HashMap<Long, GridStorage>();
    private long nextGridId;

    @Override
    public GridStorage getGridStorage(long storageID) {
        GridStorage result = this.storage.get(storageID);
        if (result == null) {
            result = new GridStorage(storageID);
            this.storage.put(storageID, result);
        }
        return result;
    }

    @Override
    public GridStorage getNewGridStorage() {
        return this.getGridStorage(this.nextGridId++);
    }

    @Override
    public void destroyGridStorage(long id) {
        this.storage.remove(id);
    }

    public static GridStorageSaveData load(class_2487 tag) {
        GridStorageSaveData result = new GridStorageSaveData();
        result.nextGridId = tag.method_10537(TAG_NEXT_ID);
        class_2487 storageTag = tag.method_10562(TAG_STORAGE);
        for (String storageIdStr : storageTag.method_10541()) {
            long storageId;
            try {
                storageId = Long.parseLong(storageIdStr);
            }
            catch (NumberFormatException e) {
                AELog.warn("Unable to load grid storage with malformed id: '{}'", storageIdStr);
                continue;
            }
            result.storage.put(storageId, new GridStorage(storageId, storageTag.method_10562(storageIdStr)));
        }
        return result;
    }

    public class_2487 method_75(class_2487 tag) {
        tag.method_10544(TAG_NEXT_ID, this.nextGridId);
        class_2487 storageTag = new class_2487();
        for (Map.Entry<Long, GridStorage> entry : this.storage.entrySet()) {
            GridStorage gridStorage = entry.getValue();
            if (gridStorage.getGrid() == null || gridStorage.getGrid().isEmpty()) continue;
            try {
                entry.getValue().saveState();
            }
            catch (Exception e) {
                AELog.warn("Failed to save state of Grid {}, storing last known value instead.", entry.getKey(), e);
            }
            storageTag.method_10566(String.valueOf(entry.getKey()), (class_2520)entry.getValue().dataObject());
        }
        tag.method_10566(TAG_STORAGE, (class_2520)storageTag);
        return tag;
    }

    public boolean method_79() {
        return true;
    }
}

