/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.execution;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.IPatternDetails;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.CraftingJobStatusPacket;
import appeng.crafting.CraftingLink;
import appeng.crafting.execution.CraftingCpuHelper;
import appeng.crafting.execution.CraftingSubmitResult;
import appeng.crafting.execution.ElapsedTimeTracker;
import appeng.crafting.execution.ExecutingCraftingJob;
import appeng.crafting.inv.ListCraftingInventory;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.service.CraftingService;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class CraftingCpuLogic {
    final CraftingCPUCluster cluster;
    private ExecutingCraftingJob job = null;
    private final ListCraftingInventory inventory = new ListCraftingInventory(this::postChange);
    private final int[] usedOps = new int[3];
    private final Set<Consumer<AEKey>> listeners = new HashSet<Consumer<AEKey>>();
    private boolean cantStoreItems = false;

    public CraftingCpuLogic(CraftingCPUCluster cluster) {
        this.cluster = cluster;
    }

    public ICraftingSubmitResult trySubmitJob(IGrid grid, ICraftingPlan plan, IActionSource src, @Nullable ICraftingRequester requester) {
        GenericStack missingIngredient;
        if (this.job != null) {
            return CraftingSubmitResult.CPU_BUSY;
        }
        if (!this.cluster.isActive()) {
            return CraftingSubmitResult.CPU_OFFLINE;
        }
        if (this.cluster.getAvailableStorage() < plan.bytes()) {
            return CraftingSubmitResult.CPU_TOO_SMALL;
        }
        if (!this.inventory.list.isEmpty()) {
            AELog.warn("Crafting CPU inventory is not empty yet a job was submitted.", new Object[0]);
        }
        if ((missingIngredient = CraftingCpuHelper.tryExtractInitialItems(plan, grid, this.inventory, src)) != null) {
            return CraftingSubmitResult.missingIngredient(missingIngredient);
        }
        Integer playerId = src.player().map(p -> {
            Integer n;
            if (p instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)p;
                n = IPlayerRegistry.getPlayerId(serverPlayer);
            } else {
                n = null;
            }
            return n;
        }).orElse(null);
        String craftId = this.generateCraftId(plan.finalOutput());
        CraftingLink linkCpu = new CraftingLink(CraftingCpuHelper.generateLinkData(craftId, requester == null, false), this.cluster);
        this.job = new ExecutingCraftingJob(plan, this::postChange, linkCpu, playerId);
        this.cluster.updateOutput(plan.finalOutput());
        this.cluster.markDirty();
        this.notifyJobOwner(this.job, CraftingJobStatusPacket.Status.STARTED);
        if (requester != null) {
            CraftingLink linkReq = new CraftingLink(CraftingCpuHelper.generateLinkData(craftId, false, true), requester);
            CraftingService craftingService = (CraftingService)grid.getCraftingService();
            craftingService.addLink(linkCpu);
            craftingService.addLink(linkReq);
            return CraftingSubmitResult.successful(linkReq);
        }
        return CraftingSubmitResult.successful(null);
    }

    public void tickCraftingLogic(IEnergyService eg, CraftingService cc) {
        int remainingOperations;
        if (!this.cluster.isActive()) {
            return;
        }
        this.cantStoreItems = false;
        if (this.job == null) {
            this.storeItems();
            if (!this.inventory.list.isEmpty()) {
                this.cantStoreItems = true;
            }
            return;
        }
        if (this.job.link.isCanceled()) {
            this.cancel();
            return;
        }
        int started = remainingOperations = this.cluster.getCoProcessors() + 1 - (this.usedOps[0] + this.usedOps[1] + this.usedOps[2]);
        if (remainingOperations > 0) {
            int pushedPatterns;
            while ((pushedPatterns = this.executeCrafting(remainingOperations, cc, eg, this.cluster.getLevel())) > 0 && (remainingOperations -= pushedPatterns) > 0) {
            }
        }
        this.usedOps[2] = this.usedOps[1];
        this.usedOps[1] = this.usedOps[0];
        this.usedOps[0] = started - remainingOperations;
    }

    public int executeCrafting(int maxPatterns, CraftingService craftingService, IEnergyService energyService, class_1937 level) {
        ExecutingCraftingJob job = this.job;
        if (job == null) {
            return 0;
        }
        int pushedPatterns = 0;
        Iterator<Map.Entry<IPatternDetails, ExecutingCraftingJob.TaskProgress>> it = job.tasks.entrySet().iterator();
        block0: while (it.hasNext()) {
            Map.Entry<IPatternDetails, ExecutingCraftingJob.TaskProgress> task = it.next();
            if (task.getValue().value <= 0L) {
                it.remove();
                continue;
            }
            IPatternDetails details = task.getKey();
            KeyCounter expectedOutputs = new KeyCounter();
            KeyCounter[] craftingContainer = CraftingCpuHelper.extractPatternInputs(details, this.inventory, level, expectedOutputs);
            for (ICraftingProvider provider : craftingService.getProviders(details)) {
                if (craftingContainer == null) break;
                if (provider.isBusy()) continue;
                double patternPower = CraftingCpuHelper.calculatePatternPower(craftingContainer);
                if (energyService.extractAEPower(patternPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) < patternPower - 0.01) break;
                if (!provider.pushPattern(details, craftingContainer)) continue;
                energyService.extractAEPower(patternPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
                ++pushedPatterns;
                for (Object2LongMap.Entry<AEKey> expectedOutput : expectedOutputs) {
                    job.waitingFor.insert((AEKey)expectedOutput.getKey(), expectedOutput.getLongValue(), Actionable.MODULATE);
                }
                this.cluster.markDirty();
                --task.getValue().value;
                if (task.getValue().value <= 0L) {
                    it.remove();
                    continue block0;
                }
                if (pushedPatterns == maxPatterns) break block0;
                expectedOutputs.reset();
                craftingContainer = CraftingCpuHelper.extractPatternInputs(details, this.inventory, level, expectedOutputs);
            }
            if (craftingContainer == null) continue;
            CraftingCpuHelper.reinjectPatternInputs(this.inventory, craftingContainer);
        }
        return pushedPatterns;
    }

    public long insert(AEKey what, long amount, Actionable type) {
        if (what == null || this.job == null) {
            return 0L;
        }
        long waitingFor = this.job.waitingFor.extract(what, amount, Actionable.SIMULATE);
        if (waitingFor <= 0L) {
            return 0L;
        }
        if (amount > waitingFor) {
            amount = waitingFor;
        }
        if (type == Actionable.MODULATE) {
            this.job.timeTracker.decrementItems(amount);
            this.job.waitingFor.extract(what, amount, Actionable.MODULATE);
            this.cluster.markDirty();
        }
        long inserted = amount;
        if (what.matches(this.job.finalOutput)) {
            inserted = this.job.link.insert(what, amount, type);
            if (type == Actionable.MODULATE) {
                this.postChange(what);
                this.job.remainingAmount = Math.max(0L, this.job.remainingAmount - amount);
                if (this.job.remainingAmount <= 0L) {
                    this.finishJob(true);
                    this.cluster.updateOutput(null);
                } else {
                    this.cluster.updateOutput(new GenericStack(this.job.finalOutput.what(), this.job.remainingAmount));
                }
            }
        } else if (type == Actionable.MODULATE) {
            this.inventory.insert(what, amount, Actionable.MODULATE);
        }
        return inserted;
    }

    private void finishJob(boolean success) {
        if (success) {
            this.job.link.markDone();
        } else {
            this.job.link.cancel();
        }
        this.job.waitingFor.clear();
        for (Map.Entry<IPatternDetails, ExecutingCraftingJob.TaskProgress> entry : this.job.tasks.entrySet()) {
            for (GenericStack output : entry.getKey().getOutputs()) {
                this.postChange(output.what());
            }
        }
        this.notifyJobOwner(this.job, success ? CraftingJobStatusPacket.Status.FINISHED : CraftingJobStatusPacket.Status.CANCELLED);
        this.job = null;
        this.storeItems();
    }

    public void cancel() {
        if (this.job == null) {
            return;
        }
        this.cluster.updateOutput(null);
        this.finishJob(false);
    }

    public void storeItems() {
        Preconditions.checkState((this.job == null ? 1 : 0) != 0, (Object)"CPU should not have a job to prevent re-insertion when dumping items");
        if (this.inventory.list.isEmpty()) {
            return;
        }
        IGrid g = this.cluster.getGrid();
        if (g == null) {
            return;
        }
        MEStorage storage = g.getStorageService().getInventory();
        for (Object2LongMap.Entry<AEKey> entry : this.inventory.list) {
            this.postChange((AEKey)entry.getKey());
            long inserted = storage.insert((AEKey)entry.getKey(), entry.getLongValue(), Actionable.MODULATE, this.cluster.getSrc());
            entry.setValue(entry.getLongValue() - inserted);
        }
        this.inventory.list.removeZeros();
        this.cluster.markDirty();
    }

    private String generateCraftId(GenericStack finalOutput) {
        long now = System.currentTimeMillis();
        int hash = System.identityHashCode(this);
        int hmm = Objects.hashCode(finalOutput);
        return Long.toString(now, 36) + "-" + Integer.toString(hash, 36) + "-" + Integer.toString(hmm, 36);
    }

    private void postChange(AEKey what) {
        for (Consumer<AEKey> listener : this.listeners) {
            listener.accept(what);
        }
    }

    public boolean hasJob() {
        return this.job != null;
    }

    @Nullable
    public GenericStack getFinalJobOutput() {
        return this.job != null ? this.job.finalOutput : null;
    }

    public ElapsedTimeTracker getElapsedTimeTracker() {
        if (this.job != null) {
            return this.job.timeTracker;
        }
        return new ElapsedTimeTracker(0L);
    }

    public void readFromNBT(class_2487 data) {
        this.inventory.readFromNBT(data.method_10554("inventory", 10));
        if (data.method_10545("job")) {
            this.job = new ExecutingCraftingJob(data.method_10562("job"), this::postChange, this);
            this.cluster.updateOutput(new GenericStack(this.job.finalOutput.what(), this.job.remainingAmount));
        } else {
            this.cluster.updateOutput(null);
        }
    }

    public void writeToNBT(class_2487 data) {
        data.method_10566("inventory", (class_2520)this.inventory.writeToNBT());
        if (this.job != null) {
            data.method_10566("job", (class_2520)this.job.writeToNBT());
        }
    }

    public ICraftingLink getLastLink() {
        if (this.job != null) {
            return this.job.link;
        }
        return null;
    }

    public ListCraftingInventory getInventory() {
        return this.inventory;
    }

    public void addListener(Consumer<AEKey> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Consumer<AEKey> listener) {
        this.listeners.remove(listener);
    }

    public long getStored(AEKey template) {
        return this.inventory.extract(template, Long.MAX_VALUE, Actionable.SIMULATE);
    }

    public long getWaitingFor(AEKey template) {
        if (this.job != null) {
            return this.job.waitingFor.extract(template, Long.MAX_VALUE, Actionable.SIMULATE);
        }
        return 0L;
    }

    public void getAllWaitingFor(Set<AEKey> waitingFor) {
        if (this.job != null) {
            for (Object2LongMap.Entry<AEKey> entry : this.job.waitingFor.list) {
                waitingFor.add((AEKey)entry.getKey());
            }
        }
    }

    public long getPendingOutputs(AEKey template) {
        long count = 0L;
        if (this.job != null) {
            for (Map.Entry<IPatternDetails, ExecutingCraftingJob.TaskProgress> t : this.job.tasks.entrySet()) {
                for (GenericStack output : t.getKey().getOutputs()) {
                    if (!template.matches(output)) continue;
                    count += output.amount() * t.getValue().value;
                }
            }
        }
        return count;
    }

    public void getAllItems(KeyCounter out) {
        out.addAll(this.inventory.list);
        if (this.job != null) {
            out.addAll(this.job.waitingFor.list);
            for (Map.Entry<IPatternDetails, ExecutingCraftingJob.TaskProgress> t : this.job.tasks.entrySet()) {
                for (GenericStack output : t.getKey().getOutputs()) {
                    out.add(output.what(), output.amount() * t.getValue().value);
                }
            }
        }
    }

    public boolean isCantStoreItems() {
        return this.cantStoreItems;
    }

    private void notifyJobOwner(ExecutingCraftingJob job, CraftingJobStatusPacket.Status status) {
        Integer playerId = job.playerId;
        if (playerId == null) {
            return;
        }
        MinecraftServer server = this.cluster.getLevel().method_8503();
        class_3222 connectedPlayer = IPlayerRegistry.getConnected(server, playerId);
        if (connectedPlayer != null) {
            String jobId = job.link.getCraftingID();
            NetworkHandler.instance().sendTo(new CraftingJobStatusPacket(jobId, job.finalOutput.what(), job.finalOutput.amount(), job.remainingAmount, status), connectedPlayer);
        }
    }
}

