/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.inv;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.crafting.inv.ICraftingInventory;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;

public class ListCraftingInventory
implements ICraftingInventory {
    public final KeyCounter list = new KeyCounter();
    private final ChangeListener listener;

    public ListCraftingInventory(ChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void insert(AEKey what, long amount, Actionable mode) {
        if (mode == Actionable.MODULATE) {
            this.list.add(what, amount);
            this.listener.onChange(what);
        }
    }

    @Override
    public long extract(AEKey what, long amount, Actionable mode) {
        long extracted = Math.min(this.list.get(what), amount);
        if (mode == Actionable.MODULATE) {
            this.list.remove(what, extracted);
            this.list.removeZeros();
            this.listener.onChange(what);
        }
        return extracted;
    }

    @Override
    public Iterable<AEKey> findFuzzyTemplates(AEKey what) {
        return Iterables.transform(this.list.findFuzzy(what, FuzzyMode.IGNORE_ALL), Map.Entry::getKey);
    }

    public void clear() {
        for (Object2LongMap.Entry<AEKey> stack : this.list) {
            this.list.set((AEKey)stack.getKey(), 0L);
            this.listener.onChange((AEKey)stack.getKey());
        }
        this.list.removeZeros();
    }

    public void readFromNBT(class_2499 data) {
        this.list.clear();
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                class_2487 compound = data.method_10602(i);
                AEKey key = AEKey.fromTagGeneric(compound);
                if (key == null) continue;
                long amount = compound.method_10537("#");
                this.insert(key, amount, Actionable.MODULATE);
            }
        }
    }

    public class_2499 writeToNBT() {
        class_2499 tag = new class_2499();
        for (Object2LongMap.Entry<AEKey> entry : this.list) {
            AEKey key = (AEKey)entry.getKey();
            long amount = entry.getLongValue();
            class_2487 entryTag = key.toTagGeneric();
            entryTag.method_10544("#", amount);
            tag.add((Object)entryTag);
        }
        return tag;
    }

    @FunctionalInterface
    public static interface ChangeListener {
        public void onChange(AEKey var1);
    }
}

