/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.crafting.pattern.SmithingTablePatternEncoding;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5357;

public class AESmithingTablePattern
implements IPatternDetails,
IMolecularAssemblerSupportedPattern {
    private static final int BASE_CRAFTING_GRID_SLOT = 3;
    private static final int ADDITION_CRAFTING_GRID_SLOT = 5;
    private final AEItemKey definition;
    public final boolean canSubstitute;
    private final class_5357 recipe;
    private final class_1263 testFrame;
    private final class_1799 output;
    private final AEItemKey base;
    private final AEItemKey addition;
    private final IPatternDetails.IInput[] inputs;
    private final GenericStack[] outputs;

    public AESmithingTablePattern(AEItemKey definition, class_1937 level) {
        this.definition = definition;
        class_2487 tag = Objects.requireNonNull(definition.getTag());
        this.base = SmithingTablePatternEncoding.getBase(tag);
        this.addition = SmithingTablePatternEncoding.getAddition(tag);
        this.canSubstitute = SmithingTablePatternEncoding.canSubstitute(tag);
        class_2960 recipeId = SmithingTablePatternEncoding.getRecipeId(tag);
        this.recipe = (class_5357)level.method_8433().method_17717(class_3956.field_25388).get(recipeId);
        this.testFrame = new class_1277(2);
        this.testFrame.method_5447(0, this.base.toStack());
        this.testFrame.method_5447(1, this.addition.toStack());
        if (!this.recipe.method_8115(this.testFrame, level)) {
            throw new IllegalStateException("The recipe " + recipeId + " no longer matches the encoded input.");
        }
        this.output = this.recipe.method_8116(this.testFrame);
        if (this.output.method_7960()) {
            throw new IllegalStateException("The recipe " + recipeId + " produced an empty item stack result.");
        }
        this.inputs = new IPatternDetails.IInput[]{new Input(this.base, this.recipe.field_25389, 3), new Input(this.addition, this.recipe.field_25390, 5)};
        this.outputs = new GenericStack[]{GenericStack.fromItemStack(this.output)};
    }

    public class_2960 getRecipeId() {
        return this.recipe.method_8114();
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AESmithingTablePattern)obj).definition.equals(this.definition);
    }

    @Override
    public AEItemKey getDefinition() {
        return this.definition;
    }

    public AEItemKey getBase() {
        return this.base;
    }

    public AEItemKey getAddition() {
        return this.addition;
    }

    @Override
    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public GenericStack[] getOutputs() {
        return this.outputs;
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public class_1799 assemble(class_1263 container, class_1937 level) {
        class_1277 testContainer = new class_1277(2);
        testContainer.method_5447(0, container.method_5438(3));
        testContainer.method_5447(1, container.method_5438(5));
        if (this.recipe.method_8115((class_1263)testContainer, level)) {
            return this.recipe.method_8116((class_1263)testContainer);
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean isItemValid(int gridSlot, AEItemKey key, class_1937 level) {
        int containerSlot;
        if (key == null) {
            return false;
        }
        if (!this.canSubstitute) {
            if (gridSlot == 3) {
                return this.base.equals(key);
            }
            if (gridSlot == 5) {
                return this.addition.equals(key);
            }
            return false;
        }
        if (gridSlot == 3) {
            containerSlot = 0;
        } else if (gridSlot == 5) {
            containerSlot = 1;
        } else {
            return false;
        }
        class_1799 previousStack = this.testFrame.method_5441(containerSlot);
        this.testFrame.method_5447(containerSlot, key.toStack());
        boolean newResult = this.recipe.method_8115(this.testFrame, level) && class_1799.method_7973((class_1799)this.output, (class_1799)this.recipe.method_8116(this.testFrame));
        this.testFrame.method_5447(containerSlot, previousStack);
        return newResult;
    }

    @Override
    public boolean isSlotEnabled(int slot) {
        return slot == 3 || slot == 5;
    }

    @Override
    public void fillCraftingGrid(KeyCounter[] table, IMolecularAssemblerSupportedPattern.CraftingGridAccessor gridAccessor) {
        AEItemKey itemKey;
        Object object;
        Object2LongMap.Entry<AEKey> entry = table[0].getFirstEntry();
        if (entry != null && (object = entry.getKey()) instanceof AEItemKey) {
            itemKey = (AEItemKey)object;
            gridAccessor.set(3, itemKey.toStack());
            table[0].remove((AEKey)entry.getKey(), 1L);
        }
        if ((entry = table[1].getFirstEntry()) != null && (object = entry.getKey()) instanceof AEItemKey) {
            itemKey = (AEItemKey)object;
            gridAccessor.set(5, itemKey.toStack());
            table[1].remove((AEKey)entry.getKey(), 1L);
        }
    }

    @Override
    public class_2371<class_1799> getRemainingItems(class_1715 container) {
        return class_2371.method_10213((int)container.method_5439(), (Object)class_1799.field_8037);
    }

    private class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] possibleInputs;
        private final int gridSlot;

        private Input(AEItemKey what, class_1856 recipeIngredient, int gridSlot) {
            this.gridSlot = gridSlot;
            if (!AESmithingTablePattern.this.canSubstitute) {
                this.possibleInputs = new GenericStack[]{new GenericStack(what, 1L)};
            } else {
                class_1799[] matchingStacks = recipeIngredient.method_8105();
                this.possibleInputs = new GenericStack[matchingStacks.length + 1];
                this.possibleInputs[0] = new GenericStack(what, 1L);
                for (int i = 0; i < matchingStacks.length; ++i) {
                    this.possibleInputs[i + 1] = GenericStack.fromItemStack(matchingStacks[i]);
                }
            }
        }

        @Override
        public GenericStack[] getPossibleInputs() {
            return this.possibleInputs;
        }

        @Override
        public long getMultiplier() {
            return 1L;
        }

        @Override
        public boolean isValid(AEKey input, class_1937 level) {
            if (input.matches(this.possibleInputs[0])) {
                return true;
            }
            if (AESmithingTablePattern.this.canSubstitute() && input instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)input;
                return AESmithingTablePattern.this.isItemValid(this.gridSlot, itemKey, level);
            }
            return false;
        }

        @Override
        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

