/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.widgets;

import appeng.integration.modules.jei.widgets.AbstractWidget;
import appeng.integration.modules.jei.widgets.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_768;

public class Label
extends AbstractWidget
implements Widget {
    public final float x;
    public final float y;
    public final class_2561 text;
    private final class_327 font;
    public int color = -1;
    public int maxWidth = -1;
    public boolean shadow = true;
    private LabelAlignment align = LabelAlignment.CENTER;
    private List<FormattedLine> formattedLines = null;

    public Label(float x, float y, class_2561 text) {
        this.x = x;
        this.y = y;
        this.text = text;
        this.font = class_310.method_1551().field_1772;
    }

    public class_768 getBounds() {
        int top = Integer.MAX_VALUE;
        int bottom = Integer.MIN_VALUE;
        int left = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        for (FormattedLine formattedLine : this.getLines()) {
            top = Math.min(top, (int)formattedLine.y);
            left = Math.min(left, (int)formattedLine.x);
            bottom = Math.max(bottom, (int)(formattedLine.y + (float)formattedLine.height));
            right = Math.max(right, (int)(formattedLine.x + (float)formattedLine.width));
        }
        return new class_768(left, top, right - left, bottom - top);
    }

    @Override
    public void draw(class_4587 stack) {
        for (FormattedLine line : this.getLines()) {
            if (this.shadow) {
                this.font.method_27517(stack, line.text, line.x, line.y, this.color);
                continue;
            }
            this.font.method_27528(stack, line.text, line.x, line.y, this.color);
        }
    }

    public Label bodyColor() {
        this.color = 0x7E7E7E;
        return this;
    }

    public Label alignLeft() {
        this.align = LabelAlignment.LEFT;
        return this;
    }

    public Label alignRight() {
        this.align = LabelAlignment.RIGHT;
        return this;
    }

    public Label tooltip(class_2561 text) {
        this.setTooltipLines(List.of(text));
        return this;
    }

    public Label noShadow() {
        this.shadow = false;
        return this;
    }

    public Label bodyText() {
        this.noShadow();
        this.bodyColor();
        return this;
    }

    @Override
    public boolean hitTest(double x, double y) {
        for (FormattedLine line : this.getLines()) {
            if (!(x >= (double)line.x) || !(x < (double)(line.x + (float)line.width)) || !(y >= (double)line.y) || !(y < (double)(line.y + (float)line.height))) continue;
            return true;
        }
        return false;
    }

    private float getAlignedX(int width) {
        return switch (this.align) {
            default -> throw new IncompatibleClassChangeError();
            case LabelAlignment.LEFT -> this.x;
            case LabelAlignment.CENTER -> this.x - (float)width / 2.0f;
            case LabelAlignment.RIGHT -> this.x - (float)width;
        };
    }

    public Label maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    private List<FormattedLine> getLines() {
        if (this.formattedLines != null) {
            return this.formattedLines;
        }
        if (this.maxWidth == -1) {
            class_5481 formattedText = this.text.method_30937();
            int width = this.font.method_30880(formattedText);
            float f = this.getAlignedX(width);
            Objects.requireNonNull(this.font);
            this.formattedLines = List.of(new FormattedLine(formattedText, f, this.y, width, 9));
        } else {
            List splitLines = this.font.method_1728((class_5348)this.text, this.maxWidth);
            ArrayList<FormattedLine> formattedLines = new ArrayList<FormattedLine>(splitLines.size());
            for (int i = 0; i < splitLines.size(); ++i) {
                class_5481 splitLine = (class_5481)splitLines.get(i);
                int width = this.font.method_30880(splitLine);
                float f = this.getAlignedX(width);
                Objects.requireNonNull(this.font);
                float f2 = this.y + (float)(i * 9);
                Objects.requireNonNull(this.font);
                formattedLines.add(new FormattedLine(splitLine, f, f2, width, 9));
            }
            this.formattedLines = formattedLines;
        }
        return this.formattedLines;
    }

    private static enum LabelAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    private record FormattedLine(class_5481 text, float x, float y, int width, int height) {
    }
}

