/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei.transfer;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.integration.modules.jeirei.TransferHelper;
import appeng.integration.modules.rei.GenericEntryStackHelper;
import appeng.integration.modules.rei.transfer.AbstractTransferHandler;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class EncodePatternTransferHandler<T extends PatternEncodingTermMenu>
extends AbstractTransferHandler<T> {
    private final IngredientVisibility ingredientVisibility = new IngredientVisibility();

    public EncodePatternTransferHandler(Class<T> containerClass) {
        super(containerClass);
    }

    @Override
    protected TransferHandler.Result transferRecipe(T menu, class_1860<?> recipe, Display display, boolean doTransfer) {
        boolean craftingRecipe = this.isCraftingRecipe(recipe, display);
        if (craftingRecipe && !this.fitsIn3x3Grid(recipe, display)) {
            return TransferHandler.Result.createFailed((class_2561)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (doTransfer) {
            if (craftingRecipe) {
                EncodingHelper.encodeCraftingRecipe(menu, recipe, this.getGuiIngredientsForCrafting(display), this::isIngredientVisible);
            } else {
                EncodingHelper.encodeProcessingRecipe(menu, GenericEntryStackHelper.ofInputs(display), GenericEntryStackHelper.ofOutputs(display));
            }
        } else {
            IClientRepo repo = ((MEStorageMenu)menu).getClientRepo();
            Set<AEKey> craftableKeys = repo != null ? repo.getAllEntries().stream().filter(GridInventoryEntry::isCraftable).map(GridInventoryEntry::getWhat).collect(Collectors.toSet()) : Set.of();
            boolean anyCraftable = display.getInputEntries().stream().anyMatch(ing -> EncodePatternTransferHandler.isCraftable(craftableKeys, ing));
            List<class_2561> tooltip = TransferHelper.createEncodingTooltip(anyCraftable);
            return TransferHandler.Result.createSuccessful().blocksFurtherHandling().overrideTooltipRenderer((point, sink) -> sink.accept(Tooltip.create((Collection)tooltip))).renderer(EncodePatternTransferHandler.createErrorRenderer(craftableKeys));
        }
        return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
    }

    private boolean isIngredientVisible(class_1799 itemStack) {
        return this.ingredientVisibility.isVisible(itemStack);
    }

    private List<List<GenericStack>> getGuiIngredientsForCrafting(Display recipeLayout) {
        ArrayList<List<GenericStack>> result = new ArrayList<List<GenericStack>>(9);
        for (int i = 0; i < 9; ++i) {
            ArrayList<GenericStack> stacks = new ArrayList<GenericStack>();
            if (i < recipeLayout.getInputEntries().size()) {
                for (EntryStack entryStack : (EntryIngredient)recipeLayout.getInputEntries().get(i)) {
                    if (entryStack.getType() != VanillaEntryTypes.ITEM) continue;
                    stacks.add(GenericStack.fromItemStack((class_1799)entryStack.castValue()));
                }
            }
            result.add(stacks);
        }
        return result;
    }

    private static boolean isCraftable(Set<AEKey> craftableKeys, List<EntryStack<?>> ingredient) {
        return ingredient.stream().anyMatch(entryStack -> {
            GenericStack stack = GenericEntryStackHelper.ingredientToStack(entryStack);
            return stack != null && craftableKeys.contains(stack.what());
        });
    }

    private static TransferHandlerRenderer createErrorRenderer(Set<AEKey> craftableKeys) {
        return (matrices, mouseX, mouseY, delta, widgets, bounds, display) -> {
            for (Widget widget : widgets) {
                Slot slot;
                if (!(widget instanceof Slot) || (slot = (Slot)widget).getNoticeMark() != 1 || !EncodePatternTransferHandler.isCraftable(craftableKeys, slot.getEntries())) continue;
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 400.0);
                Rectangle innerBounds = slot.getInnerBounds();
                class_332.method_25294((class_4587)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)0x400000FF);
                matrices.method_22909();
            }
        };
    }

    private static class IngredientVisibility {
        private final EntryRegistry registry;
        private final Map<class_1799, Boolean> cache = new HashMap<class_1799, Boolean>();

        private IngredientVisibility() {
            this.registry = EntryRegistry.getInstance();
        }

        private boolean isVisible(class_1799 stack) {
            if (this.cache.containsKey(stack)) {
                return this.cache.get(stack);
            }
            EntryStack entryStack = EntryStacks.of((class_1799)stack);
            if (!this.registry.alreadyContain(entryStack)) {
                this.cache.put(stack, false);
                return false;
            }
            Collection entryStacks = this.registry.refilterNew(false, Collections.singleton(entryStack));
            boolean visible = !entryStacks.isEmpty();
            this.cache.put(stack, visible);
            return visible;
        }
    }
}

