/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.contents;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.menuobjects.IPortableTerminal;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.util.IConfigManager;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.menu.ISubMenu;
import appeng.util.ConfigManager;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class PortableCellMenuHost
extends ItemMenuHost
implements IPortableTerminal {
    private final BiConsumer<class_1657, ISubMenu> returnMainMenu;
    private final MEStorage cellStorage;
    private final AbstractPortableCell item;

    public PortableCellMenuHost(class_1657 player, @Nullable Integer slot, AbstractPortableCell item, class_1799 itemStack, BiConsumer<class_1657, ISubMenu> returnMainMenu) {
        super(player, slot, itemStack);
        Preconditions.checkArgument((itemStack.method_7909() == item ? 1 : 0) != 0, (Object)"Stack doesn't match item");
        this.returnMainMenu = returnMainMenu;
        this.cellStorage = StorageCells.getCellInventory(itemStack, null);
        Objects.requireNonNull(this.cellStorage, "Portable cell doesn't expose a cell inventory.");
        this.item = item;
    }

    @Override
    public boolean onBroadcastChanges(class_1703 menu) {
        return this.ensureItemStillInSlot() && this.drainPower();
    }

    @Override
    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        amt = usePowerMultiplier.multiply(amt);
        if (mode == Actionable.SIMULATE) {
            return usePowerMultiplier.divide(Math.min(amt, this.item.getAECurrentPower(this.getItemStack())));
        }
        return usePowerMultiplier.divide(this.item.extractAEPower(this.getItemStack(), amt, Actionable.MODULATE));
    }

    @Override
    public MEStorage getInventory() {
        return this.cellStorage;
    }

    @Override
    public IConfigManager getConfigManager() {
        ConfigManager out = new ConfigManager((manager, settingName) -> manager.writeToNBT(this.getItemStack().method_7948()));
        out.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        out.readFromNBT(this.getItemStack().method_7948().method_10553());
        return out;
    }

    @Override
    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        this.returnMainMenu.accept(player, subMenu);
    }

    @Override
    public class_1799 getMainMenuIcon() {
        return this.getItemStack();
    }
}

