/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.materials;

import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.Upgrades;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.PlayerMessages;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;

public class UpgradeCardItem
extends AEBaseItem
implements AEToolItem {
    public UpgradeCardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        super.method_7851(stack, level, lines, advancedTooltips);
        List<class_2561> supportedBy = Upgrades.getTooltipLinesForCard((class_1935)this);
        if (!supportedBy.isEmpty()) {
            lines.add((class_2561)ButtonToolTips.SupportedBy.text());
            lines.addAll(supportedBy);
        }
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        class_1657 player = context.method_8036();
        class_1268 hand = context.method_20287();
        if (player != null && InteractionUtil.isInAlternateUseMode(player)) {
            class_2586 te = context.method_8045().method_8321(context.method_8037());
            IUpgradeInventory upgrades = null;
            if (te instanceof IPartHost) {
                SelectedPart sp = ((IPartHost)te).selectPartWorld(context.method_17698());
                if (sp.part instanceof IUpgradeableObject) {
                    upgrades = ((IUpgradeableObject)((Object)sp.part)).getUpgrades();
                }
            } else if (te instanceof IUpgradeableObject) {
                upgrades = ((IUpgradeableObject)te).getUpgrades();
            }
            if (upgrades != null && upgrades.size() > 0) {
                class_1799 heldStack = player.method_5998(hand);
                boolean isFull = true;
                for (int i = 0; i < upgrades.size(); ++i) {
                    if (!upgrades.getStackInSlot(i).method_7960()) continue;
                    isFull = false;
                    break;
                }
                if (isFull) {
                    player.method_43496((class_2561)PlayerMessages.MaxUpgradesInstalled.text());
                    return class_1269.field_5814;
                }
                int maxInstalled = upgrades.getMaxInstalled((class_1935)heldStack.method_7909());
                int installed = upgrades.getInstalledUpgrades((class_1935)heldStack.method_7909());
                if (maxInstalled <= 0) {
                    player.method_43496((class_2561)PlayerMessages.UnsupportedUpgrade.text());
                    return class_1269.field_5814;
                }
                if (installed >= maxInstalled) {
                    player.method_43496((class_2561)PlayerMessages.MaxUpgradesOfTypeInstalled.text());
                    return class_1269.field_5814;
                }
                if (player.method_5770().method_8608()) {
                    return class_1269.field_5811;
                }
                player.method_6122(hand, upgrades.addItems(heldStack));
                return class_1269.method_29236((boolean)player.method_5770().method_8608());
            }
        }
        return class_1269.field_5811;
    }
}

