/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.service;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.events.GridSecurityChange;
import appeng.api.networking.security.ISecurityProvider;
import appeng.api.networking.security.ISecurityService;
import appeng.core.AEConfig;
import appeng.me.GridNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class SecurityService
implements ISecurityService,
IGridServiceProvider {
    private final IGrid myGrid;
    private final List<ISecurityProvider> securityProvider = new ArrayList<ISecurityProvider>();
    private final HashMap<Integer, EnumSet<SecurityPermissions>> playerPerms = new HashMap();
    private long securityKey = -1L;

    public SecurityService(IGrid g) {
        this.myGrid = g;
    }

    private void updatePermissions() {
        this.playerPerms.clear();
        if (this.securityProvider.isEmpty()) {
            return;
        }
        this.securityProvider.get(0).readPermissions(this.playerPerms);
    }

    public long getSecurityKey() {
        return this.securityKey;
    }

    @Override
    public void removeNode(IGridNode gridNode) {
        ISecurityProvider security = gridNode.getService(ISecurityProvider.class);
        if (security != null) {
            this.securityProvider.remove(security);
            this.updateSecurityKey();
        }
    }

    private void updateSecurityKey() {
        long lastCode = this.securityKey;
        int newOwner = -1;
        if (this.securityProvider.size() == 1) {
            ISecurityProvider securityProvider = this.securityProvider.get(0);
            this.securityKey = securityProvider.getSecurityKey();
            newOwner = securityProvider.getOwner();
        } else {
            this.securityKey = -1L;
        }
        if (lastCode != this.securityKey) {
            this.getGrid().postEvent(new GridSecurityChange());
            for (IGridNode n : this.getGrid().getNodes()) {
                GridNode gridNode = (GridNode)n;
                gridNode.setLastSecurityKey(this.securityKey);
                if (gridNode.getOwningPlayerId() == newOwner) continue;
                gridNode.setOwningPlayerId(newOwner);
            }
        }
    }

    @Override
    public void addNode(IGridNode gridNode) {
        ISecurityProvider security = gridNode.getService(ISecurityProvider.class);
        if (security != null) {
            this.securityProvider.add(security);
            this.updateSecurityKey();
        } else {
            ((GridNode)gridNode).setLastSecurityKey(this.securityKey);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.securityProvider.size() == 1 && this.securityProvider.get(0).isSecurityEnabled();
    }

    @Override
    public boolean hasPermission(class_1657 player, SecurityPermissions perm) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(perm);
        if (AEConfig.instance().serverOpsIgnoreSecurity() && player.method_5687(4)) {
            return true;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            int playerID = IPlayerRegistry.getPlayerId(serverPlayer);
            return this.hasPermission(playerID, perm);
        }
        return false;
    }

    @Override
    public boolean hasPermission(int playerID, SecurityPermissions perm) {
        if (this.isAvailable()) {
            EnumSet<SecurityPermissions> perms = this.playerPerms.get(playerID);
            if (perms == null) {
                if (playerID == -1) {
                    return true;
                }
                return this.hasPermission(-1, perm);
            }
            return perms.contains((Object)perm);
        }
        return true;
    }

    @Override
    public int getOwner() {
        if (this.isAvailable()) {
            return this.securityProvider.get(0).getOwner();
        }
        return -1;
    }

    public IGrid getGrid() {
        return this.myGrid;
    }

    static {
        GridHelper.addGridServiceEventHandler(GridSecurityChange.class, ISecurityService.class, (service, event) -> ((SecurityService)service).updatePermissions());
    }
}

