/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.blockentity.crafting.MolecularAssemblerBlockEntity;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.MolecularAssemblerPatternSlot;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3917;

public class MolecularAssemblerMenu
extends UpgradeableMenu<MolecularAssemblerBlockEntity>
implements IProgressProvider {
    public static final class_3917<MolecularAssemblerMenu> TYPE = MenuTypeBuilder.create(MolecularAssemblerMenu::new, MolecularAssemblerBlockEntity.class).build("molecular_assembler");
    private static final int MAX_CRAFT_PROGRESS = 100;
    private final MolecularAssemblerBlockEntity molecularAssembler;
    @GuiSync(value=4)
    public int craftProgress = 0;
    private class_1735 encodedPatternSlot;

    public MolecularAssemblerMenu(int id, class_1661 playerInv, MolecularAssemblerBlockEntity be) {
        super((class_3917<?>)TYPE, id, playerInv, be);
        this.molecularAssembler = be;
    }

    public boolean isValidItemForSlot(int slotIndex, class_1799 i) {
        IMolecularAssemblerSupportedPattern details = this.molecularAssembler.getCurrentPattern();
        if (details != null) {
            return details.isItemValid(slotIndex, AEItemKey.of(i), this.molecularAssembler.method_10997());
        }
        return false;
    }

    @Override
    protected void setupConfig() {
        InternalInventory mac = ((MolecularAssemblerBlockEntity)this.getHost()).getSubInventory(MolecularAssemblerBlockEntity.INV_MAIN);
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new MolecularAssemblerPatternSlot(this, mac, i), SlotSemantics.MACHINE_CRAFTING_GRID);
        }
        this.encodedPatternSlot = this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.MOLECULAR_ASSEMBLER_PATTERN, mac, 10), SlotSemantics.ENCODED_PATTERN);
        this.addSlot(new OutputSlot(mac, 9, null), SlotSemantics.MACHINE_OUTPUT);
    }

    @Override
    public void method_7623() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        this.craftProgress = this.molecularAssembler.getCraftingProgress();
        this.standardDetectAndSendChanges();
    }

    @Override
    public int getCurrentProgress() {
        return this.craftProgress;
    }

    @Override
    public int getMaxProgress() {
        return 100;
    }

    @Override
    public void onSlotChange(class_1735 s) {
        if (s == this.encodedPatternSlot) {
            for (class_1735 otherSlot : this.field_7761) {
                if (otherSlot == s || !(otherSlot instanceof AppEngSlot)) continue;
                ((AppEngSlot)otherSlot).resetCachedValidation();
            }
        }
    }
}

