/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.helpers.IPriorityHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.implementations.MenuTypeBuilder;
import net.minecraft.class_1661;
import net.minecraft.class_3917;

public class PriorityMenu
extends AEBaseMenu
implements ISubMenu {
    private static final String ACTION_SET_PRIORITY = "setPriority";
    public static final class_3917<PriorityMenu> TYPE = MenuTypeBuilder.create(PriorityMenu::new, IPriorityHost.class).requirePermission(SecurityPermissions.BUILD).withInitialData((host, buffer) -> buffer.method_10804(host.getPriority()), (host, menu, buffer) -> {
        menu.priorityValue = buffer.method_10816();
    }).build("priority");
    private final IPriorityHost host;
    private int priorityValue;

    public PriorityMenu(int id, class_1661 ip, IPriorityHost host) {
        super(TYPE, id, ip, host);
        this.host = host;
        this.priorityValue = host.getPriority();
        this.registerClientAction(ACTION_SET_PRIORITY, Integer.class, this::setPriority);
    }

    public void setPriority(int newValue) {
        if (newValue != this.priorityValue) {
            if (this.isClientSide()) {
                this.priorityValue = newValue;
                this.sendClientAction(ACTION_SET_PRIORITY, newValue);
            } else {
                this.host.setPriority(newValue);
                this.priorityValue = newValue;
            }
        }
    }

    @Override
    public void method_7623() {
        super.method_7623();
        this.verifyPermissions(SecurityPermissions.BUILD, false);
    }

    public int getPriorityValue() {
        return this.priorityValue;
    }

    @Override
    public IPriorityHost getHost() {
        return this.host;
    }
}

