/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.interaction;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.menu.me.interaction.ContainerItemContext;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.FluidContainerItemStrategy;
import appeng.util.CowMap;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class StackInteractions {
    private static final CowMap<AEKeyType, ContainerItemStrategy<?, ?>> strategies = CowMap.identityHashMap();

    public static <T extends AEKey> void register(AEKeyType type, Class<T> keyClass, ContainerItemStrategy<T, ?> strategy) {
        Preconditions.checkArgument((type.getKeyClass() == keyClass ? 1 : 0) != 0, (String)"%s != %s", type.getKeyClass(), keyClass);
        Preconditions.checkArgument((type != AEKeyType.items() ? 1 : 0) != 0, (Object)"Can't register container items for AEItemKey");
        strategies.putIfAbsent(type, strategy);
    }

    public static boolean isTypeSupported(AEKeyType type) {
        return strategies.getMap().containsKey(type);
    }

    public static boolean isKeySupported(@Nullable AEKey key) {
        return key != null && StackInteractions.isTypeSupported(key.getType());
    }

    @Nullable
    public static GenericStack getContainedStack(class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        for (Map.Entry<AEKeyType, ContainerItemStrategy<?, ?>> entry : strategies.getMap().entrySet()) {
            GenericStack content = entry.getValue().getContainedStack(stack);
            if (content == null) continue;
            return content;
        }
        return null;
    }

    @Nullable
    public static GenericStack getContainedStack(class_1799 stack, AEKeyType keyType) {
        if (stack.method_7960()) {
            return null;
        }
        ContainerItemStrategy<?, ?> strategy = strategies.getMap().get(keyType);
        if (strategy != null) {
            return strategy.getContainedStack(stack);
        }
        return null;
    }

    @Nullable
    public static EmptyingAction getEmptyingAction(class_1799 stack) {
        GenericStack contents = StackInteractions.getContainedStack(stack);
        if (contents == null) {
            return null;
        }
        class_2561 description = contents.what().getDisplayName();
        return new EmptyingAction(description, contents.what(), contents.amount());
    }

    public static ContainerItemContext findCarriedContextForKey(@Nullable AEKey key, class_1657 player, class_1703 menu) {
        return StackInteractions.findCarriedContext(key == null ? null : key.getType(), player, menu);
    }

    @Nullable
    public static ContainerItemContext findCarriedContext(@Nullable AEKeyType keyType, class_1657 player, class_1703 menu) {
        Collection<AEKeyType> candidates = keyType == null ? strategies.getMap().keySet() : List.of(keyType);
        for (AEKeyType type : candidates) {
            Object context;
            ContainerItemStrategy<AEKey, Object> strategy = strategies.getMap().get(type);
            if (strategy == null || (context = strategy.findCarriedContext(player, menu)) == null) continue;
            return new ContainerItemContext(strategy, context, type);
        }
        return null;
    }

    public static Set<AEKeyType> getSupportedKeyTypes() {
        return strategies.getMap().keySet();
    }

    @Nullable
    public static ContainerItemContext findOwnedItemContext(@Nullable AEKeyType keyType, class_1657 player, class_1799 stack) {
        if (player.field_7512 != null && player.field_7512.method_34255() == stack) {
            return StackInteractions.findCarriedContext(keyType, player, player.field_7512);
        }
        int slotIdx = -1;
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (inventory.method_5438(i) != stack) continue;
            slotIdx = i;
            break;
        }
        if (slotIdx == -1) {
            return null;
        }
        Collection<AEKeyType> candidates = keyType == null ? strategies.getMap().keySet() : List.of(keyType);
        for (AEKeyType type : candidates) {
            Object context;
            ContainerItemStrategy<AEKey, Object> strategy = strategies.getMap().get(type);
            if (strategy == null || (context = strategy.findPlayerSlotContext(player, slotIdx)) == null) continue;
            return new ContainerItemContext(strategy, context, type);
        }
        return null;
    }

    static {
        StackInteractions.register(AEKeyType.fluids(), AEFluidKey.class, new FluidContainerItemStrategy());
    }
}

