/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.items;

import appeng.api.config.SecurityPermissions;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.Icon;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.PatternTermSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.parts.encoding.PatternEncodingLogic;
import appeng.util.ConfigInventory;
import appeng.util.ConfigMenuInventory;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_5357;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class PatternEncodingTermMenu
extends MEStorageMenu
implements IMenuCraftingPacket {
    private static final int CRAFTING_GRID_WIDTH = 3;
    private static final int CRAFTING_GRID_HEIGHT = 3;
    private static final int CRAFTING_GRID_SLOTS = 9;
    private static final String ACTION_SET_MODE = "setMode";
    private static final String ACTION_ENCODE = "encode";
    private static final String ACTION_CLEAR = "clear";
    private static final String ACTION_SET_SUBSTITUTION = "setSubstitution";
    private static final String ACTION_SET_FLUID_SUBSTITUTION = "setFluidSubstitution";
    private static final String ACTION_SET_STONECUTTING_RECIPE_ID = "setStonecuttingRecipeId";
    private static final String ACTION_CYCLE_PROCESSING_OUTPUT = "cycleProcessingOutput";
    public static class_3917<PatternEncodingTermMenu> TYPE = MenuTypeBuilder.create(PatternEncodingTermMenu::new, IPatternTerminalMenuHost.class).requirePermission(SecurityPermissions.CRAFT).build("patternterm");
    private final PatternEncodingLogic encodingLogic;
    private final FakeSlot[] craftingGridSlots = new FakeSlot[9];
    private final FakeSlot[] processingInputSlots = new FakeSlot[81];
    private final FakeSlot[] processingOutputSlots = new FakeSlot[27];
    private final FakeSlot stonecuttingInputSlot;
    private final FakeSlot smithingTableBaseSlot;
    private final FakeSlot smithingTableAdditionSlot;
    private final PatternTermSlot craftOutputSlot;
    private final RestrictedInputSlot blankPatternSlot;
    private final RestrictedInputSlot encodedPatternSlot;
    private final ConfigInventory encodedInputsInv;
    private final ConfigInventory encodedOutputsInv;
    private class_3955 currentRecipe;
    private EncodingMode currentMode;
    @GuiSync(value=97)
    public EncodingMode mode = EncodingMode.CRAFTING;
    @GuiSync(value=96)
    public boolean substitute = false;
    @GuiSync(value=95)
    public boolean substituteFluids = true;
    @GuiSync(value=94)
    @Nullable
    public class_2960 stonecuttingRecipeId;
    private final List<class_3975> stonecuttingRecipes = new ArrayList<class_3975>();
    public IntSet slotsSupportingFluidSubstitution = new IntArraySet();

    public PatternEncodingTermMenu(int id, class_1661 ip, IPatternTerminalMenuHost host) {
        this(TYPE, id, ip, host, true);
    }

    public PatternEncodingTermMenu(class_3917<?> menuType, int id, class_1661 ip, IPatternTerminalMenuHost host, boolean bindInventory) {
        super(menuType, id, ip, host, bindInventory);
        int i;
        this.encodingLogic = host.getLogic();
        this.encodedInputsInv = this.encodingLogic.getEncodedInputInv();
        this.encodedOutputsInv = this.encodingLogic.getEncodedOutputInv();
        ConfigMenuInventory encodedInputs = this.encodedInputsInv.createMenuWrapper();
        ConfigMenuInventory encodedOutputs = this.encodedOutputsInv.createMenuWrapper();
        for (i = 0; i < 9; ++i) {
            FakeSlot slot = new FakeSlot(encodedInputs, i);
            slot.setHideAmount(true);
            this.craftingGridSlots[i] = slot;
            this.addSlot(this.craftingGridSlots[i], SlotSemantics.CRAFTING_GRID);
        }
        this.craftOutputSlot = new PatternTermSlot(ip.field_7546, this.getActionSource(), this.powerSource, host.getInventory(), encodedInputs, this);
        this.addSlot(this.craftOutputSlot, SlotSemantics.CRAFTING_RESULT);
        this.craftOutputSlot.setIcon(null);
        for (i = 0; i < this.processingInputSlots.length; ++i) {
            this.processingInputSlots[i] = new FakeSlot(encodedInputs, i);
            this.addSlot(this.processingInputSlots[i], SlotSemantics.PROCESSING_INPUTS);
        }
        for (i = 0; i < this.processingOutputSlots.length; ++i) {
            this.processingOutputSlots[i] = new FakeSlot(encodedOutputs, i);
            this.addSlot(this.processingOutputSlots[i], SlotSemantics.PROCESSING_OUTPUTS);
        }
        this.processingOutputSlots[0].setIcon(Icon.BACKGROUND_PRIMARY_OUTPUT);
        this.stonecuttingInputSlot = new FakeSlot(encodedInputs, 0);
        this.addSlot(this.stonecuttingInputSlot, SlotSemantics.STONECUTTING_INPUT);
        this.stonecuttingInputSlot.setHideAmount(true);
        this.smithingTableBaseSlot = new FakeSlot(encodedInputs, 0);
        this.addSlot(this.smithingTableBaseSlot, SlotSemantics.SMITHING_TABLE_BASE);
        this.smithingTableBaseSlot.setHideAmount(true);
        this.smithingTableAdditionSlot = new FakeSlot(encodedInputs, 1);
        this.addSlot(this.smithingTableAdditionSlot, SlotSemantics.SMITHING_TABLE_ADDITION);
        this.smithingTableAdditionSlot.setHideAmount(true);
        this.blankPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, this.encodingLogic.getBlankPatternInv(), 0);
        this.addSlot(this.blankPatternSlot, SlotSemantics.BLANK_PATTERN);
        this.encodedPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, this.encodingLogic.getEncodedPatternInv(), 0);
        this.addSlot(this.encodedPatternSlot, SlotSemantics.ENCODED_PATTERN);
        this.encodedPatternSlot.setStackLimit(1);
        this.registerClientAction(ACTION_ENCODE, this::encode);
        this.registerClientAction(ACTION_SET_STONECUTTING_RECIPE_ID, class_2960.class, this.encodingLogic::setStonecuttingRecipeId);
        this.registerClientAction(ACTION_CLEAR, this::clear);
        this.registerClientAction(ACTION_SET_MODE, EncodingMode.class, this.encodingLogic::setMode);
        this.registerClientAction(ACTION_SET_SUBSTITUTION, Boolean.class, this.encodingLogic::setSubstitution);
        this.registerClientAction(ACTION_SET_FLUID_SUBSTITUTION, Boolean.class, this.encodingLogic::setFluidSubstitution);
        this.registerClientAction(ACTION_CYCLE_PROCESSING_OUTPUT, this::cycleProcessingOutput);
        this.updateStonecuttingRecipes();
    }

    public void method_7619(int slotID, int stateId, class_1799 stack) {
        super.method_7619(slotID, stateId, stack);
        this.getAndUpdateOutput();
    }

    private class_1799 getAndUpdateOutput() {
        class_1937 level = this.getPlayerInventory().field_7546.field_6002;
        class_1715 ic = new class_1715((class_1703)this, 3, 3);
        boolean invalidIngredients = false;
        for (int x = 0; x < ic.method_5439(); ++x) {
            class_1799 stack = this.getEncodedCraftingIngredient(x);
            if (stack != null) {
                ic.method_5447(x, stack);
                continue;
            }
            invalidIngredients = true;
        }
        if (this.currentRecipe == null || !this.currentRecipe.method_8115((class_1263)ic, level)) {
            this.currentRecipe = invalidIngredients ? null : (class_3955)level.method_8433().method_8132(class_3956.field_17545, (class_1263)ic, level).orElse(null);
            this.currentMode = this.mode;
            this.checkFluidSubstitutionSupport();
        }
        class_1799 is = this.currentRecipe == null ? class_1799.field_8037 : this.currentRecipe.method_8116((class_1263)ic);
        this.craftOutputSlot.setDisplayedCraftingOutput(is);
        return is;
    }

    private void checkFluidSubstitutionSupport() {
        IPatternDetails decodedPattern;
        this.slotsSupportingFluidSubstitution.clear();
        if (this.currentRecipe == null) {
            return;
        }
        class_1799 encodedPattern = this.encodePattern();
        if (encodedPattern != null && (decodedPattern = PatternDetailsHelper.decodePattern(encodedPattern, this.getPlayerInventory().field_7546.field_6002)) instanceof AECraftingPattern) {
            AECraftingPattern craftingPattern = (AECraftingPattern)decodedPattern;
            for (int i = 0; i < craftingPattern.getSparseInputs().length; ++i) {
                if (craftingPattern.getValidFluid(i) == null) continue;
                this.slotsSupportingFluidSubstitution.add(i);
            }
        }
    }

    public void encode() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_ENCODE);
            return;
        }
        class_1799 encodedPattern = this.encodePattern();
        if (encodedPattern != null) {
            class_1799 encodeOutput = this.encodedPatternSlot.method_7677();
            if (!(encodeOutput.method_7960() || PatternDetailsHelper.isEncodedPattern(encodeOutput) || AEItems.BLANK_PATTERN.isSameAs(encodeOutput))) {
                return;
            }
            if (encodeOutput.method_7960()) {
                class_1799 blankPattern = this.blankPatternSlot.method_7677();
                if (!this.isPattern(blankPattern)) {
                    return;
                }
                blankPattern.method_7934(1);
                if (blankPattern.method_7947() <= 0) {
                    this.blankPatternSlot.method_7673(class_1799.field_8037);
                }
            }
            this.encodedPatternSlot.method_7673(encodedPattern);
        } else {
            this.clearPattern();
        }
    }

    private void clearPattern() {
        class_1799 encodedPattern = this.encodedPatternSlot.method_7677();
        if (PatternDetailsHelper.isEncodedPattern(encodedPattern)) {
            this.encodedPatternSlot.method_7673(AEItems.BLANK_PATTERN.stack(encodedPattern.method_7947()));
        }
    }

    @Nullable
    private class_1799 encodePattern() {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case EncodingMode.CRAFTING -> this.encodeCraftingPattern();
            case EncodingMode.PROCESSING -> this.encodeProcessingPattern();
            case EncodingMode.SMITHING_TABLE -> this.encodeSmithingTablePattern();
            case EncodingMode.STONECUTTING -> this.encodeStonecuttingPattern();
        };
    }

    @Nullable
    private class_1799 encodeCraftingPattern() {
        class_1799[] ingredients = new class_1799[9];
        boolean valid = false;
        for (int x = 0; x < ingredients.length; ++x) {
            ingredients[x] = this.getEncodedCraftingIngredient(x);
            if (ingredients[x] == null) {
                return null;
            }
            if (ingredients[x].method_7960()) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        class_1799 result = this.getAndUpdateOutput();
        if (result.method_7960() || this.currentRecipe == null) {
            return null;
        }
        return PatternDetailsHelper.encodeCraftingPattern(this.currentRecipe, ingredients, result, this.isSubstitute(), this.isSubstituteFluids());
    }

    @Nullable
    private class_1799 encodeProcessingPattern() {
        GenericStack[] inputs = new GenericStack[this.encodedInputsInv.size()];
        boolean valid = false;
        for (int slot = 0; slot < this.encodedInputsInv.size(); ++slot) {
            inputs[slot] = this.encodedInputsInv.getStack(slot);
            if (inputs[slot] == null) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        GenericStack[] outputs = new GenericStack[this.encodedOutputsInv.size()];
        for (int slot = 0; slot < this.encodedOutputsInv.size(); ++slot) {
            outputs[slot] = this.encodedOutputsInv.getStack(slot);
        }
        if (outputs[0] == null) {
            return null;
        }
        return PatternDetailsHelper.encodeProcessingPattern(inputs, outputs);
    }

    @Nullable
    private class_1799 encodeSmithingTablePattern() {
        AEItemKey base;
        AEKey aEKey;
        block5: {
            block4: {
                aEKey = this.encodedInputsInv.getKey(0);
                if (!(aEKey instanceof AEItemKey)) break block4;
                base = (AEItemKey)aEKey;
                aEKey = this.encodedInputsInv.getKey(1);
                if (aEKey instanceof AEItemKey) break block5;
            }
            return null;
        }
        AEItemKey addition = (AEItemKey)aEKey;
        class_1277 container = new class_1277(2);
        container.method_5447(0, base.toStack());
        container.method_5447(1, addition.toStack());
        class_1937 level = this.getPlayer().field_6002;
        class_5357 recipe = level.method_8433().method_8132(class_3956.field_25388, (class_1263)container, level).orElse(null);
        if (recipe == null) {
            return null;
        }
        AEItemKey output = AEItemKey.of(recipe.method_8116((class_1263)container));
        return PatternDetailsHelper.encodeSmithingTablePattern(recipe, base, addition, output, this.encodingLogic.isSubstitution());
    }

    @Nullable
    private class_1799 encodeStonecuttingPattern() {
        if (this.stonecuttingRecipeId == null) {
            return null;
        }
        AEKey aEKey = this.encodedInputsInv.getKey(0);
        if (!(aEKey instanceof AEItemKey)) {
            return null;
        }
        AEItemKey input = (AEItemKey)aEKey;
        class_1277 container = new class_1277(1);
        container.method_5447(0, input.toStack());
        class_1937 level = this.getPlayer().field_6002;
        class_3975 recipe = level.method_8433().method_42299(class_3956.field_17641, (class_1263)container, level, this.stonecuttingRecipeId).map(Pair::getSecond).orElse(null);
        if (recipe == null) {
            return null;
        }
        AEItemKey output = AEItemKey.of(recipe.method_8110());
        return PatternDetailsHelper.encodeStonecuttingPattern(recipe, input, output, this.encodingLogic.isSubstitution());
    }

    @Nullable
    private class_1799 getEncodedCraftingIngredient(int slot) {
        AEKey what = this.encodedInputsInv.getKey(slot);
        if (what == null) {
            return class_1799.field_8037;
        }
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            return itemKey.toStack(1);
        }
        return null;
    }

    private boolean isPattern(class_1799 output) {
        if (output.method_7960()) {
            return false;
        }
        return AEItems.BLANK_PATTERN.isSameAs(output);
    }

    @Override
    public void method_7623() {
        super.method_7623();
        if (this.isServerSide()) {
            if (this.mode != this.encodingLogic.getMode()) {
                this.setMode(this.encodingLogic.getMode());
            }
            this.substitute = this.encodingLogic.isSubstitution();
            this.substituteFluids = this.encodingLogic.isFluidSubstitution();
            this.stonecuttingRecipeId = this.encodingLogic.getStonecuttingRecipeId();
        }
    }

    @Override
    public void onServerDataSync() {
        super.onServerDataSync();
        for (FakeSlot slot : this.craftingGridSlots) {
            slot.setActive(this.mode == EncodingMode.CRAFTING);
        }
        this.craftOutputSlot.setActive(this.mode == EncodingMode.CRAFTING);
        for (FakeSlot slot : this.processingInputSlots) {
            slot.setActive(this.mode == EncodingMode.PROCESSING);
        }
        for (FakeSlot slot : this.processingOutputSlots) {
            slot.setActive(this.mode == EncodingMode.PROCESSING);
        }
        if (this.currentMode != this.mode) {
            this.encodingLogic.setMode(this.mode);
            this.getAndUpdateOutput();
            this.updateStonecuttingRecipes();
        }
    }

    @Override
    public void onSlotChange(class_1735 s) {
        if (s == this.encodedPatternSlot && this.isServerSide()) {
            this.method_7623();
        }
        if (s == this.craftOutputSlot && this.isClientSide()) {
            this.getAndUpdateOutput();
        }
        if (s == this.stonecuttingInputSlot) {
            this.updateStonecuttingRecipes();
        }
    }

    private void updateStonecuttingRecipes() {
        this.stonecuttingRecipes.clear();
        AEKey aEKey = this.encodedInputsInv.getKey(0);
        if (aEKey instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            class_1937 level = this.getPlayer().field_6002;
            class_1863 recipeManager = level.method_8433();
            class_1277 inventory = new class_1277(1);
            inventory.method_5447(0, itemKey.toStack());
            this.stonecuttingRecipes.addAll(recipeManager.method_17877(class_3956.field_17641, (class_1263)inventory, level));
        }
        if (this.stonecuttingRecipeId != null && this.stonecuttingRecipes.stream().noneMatch(r -> r.method_8114().equals((Object)this.stonecuttingRecipeId))) {
            this.stonecuttingRecipeId = null;
        }
    }

    public void clear() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CLEAR);
            return;
        }
        this.encodedInputsInv.clear();
        this.encodedOutputsInv.clear();
        this.method_7623();
        this.getAndUpdateOutput();
    }

    @Override
    public InternalInventory getCraftingMatrix() {
        return this.encodedInputsInv.createMenuWrapper().getSubInventory(0, 9);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public EncodingMode getMode() {
        return this.mode;
    }

    public void setMode(EncodingMode mode) {
        if (this.mode != mode && mode == EncodingMode.STONECUTTING) {
            this.updateStonecuttingRecipes();
        }
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_MODE, mode);
        } else {
            this.mode = mode;
        }
    }

    public boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_SUBSTITUTION, substitute);
        } else {
            this.substitute = substitute;
        }
    }

    public boolean isSubstituteFluids() {
        return this.substituteFluids;
    }

    public void setSubstituteFluids(boolean substituteFluids) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_FLUID_SUBSTITUTION, substituteFluids);
        } else {
            this.substituteFluids = substituteFluids;
        }
    }

    @Nullable
    public class_2960 getStonecuttingRecipeId() {
        return this.stonecuttingRecipeId;
    }

    public void setStonecuttingRecipeId(class_2960 id) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_STONECUTTING_RECIPE_ID, id);
        } else {
            this.encodingLogic.setStonecuttingRecipeId(id);
        }
    }

    @Override
    protected class_1799 transferStackToMenu(class_1799 input) {
        if (this.blankPatternSlot.method_7680(input) && (input = this.blankPatternSlot.method_32756(input)).method_7960()) {
            return class_1799.field_8037;
        }
        if (this.encodedPatternSlot.method_7680(input) && (input = this.encodedPatternSlot.method_32756(input)).method_7960()) {
            return class_1799.field_8037;
        }
        return super.transferStackToMenu(input);
    }

    @Contract(value="null -> false")
    public boolean canModifyAmountForSlot(@Nullable class_1735 slot) {
        return this.isProcessingPatternSlot(slot) && slot.method_7681();
    }

    @Contract(value="null -> false")
    public boolean isProcessingPatternSlot(@Nullable class_1735 slot) {
        if (slot == null || this.mode != EncodingMode.PROCESSING) {
            return false;
        }
        for (FakeSlot processingOutputSlot : this.processingOutputSlots) {
            if (processingOutputSlot != slot) continue;
            return true;
        }
        for (FakeSlot craftingSlot : this.processingInputSlots) {
            if (craftingSlot != slot) continue;
            return true;
        }
        return false;
    }

    public FakeSlot[] getCraftingGridSlots() {
        return this.craftingGridSlots;
    }

    public FakeSlot[] getProcessingInputSlots() {
        return this.processingInputSlots;
    }

    public FakeSlot[] getProcessingOutputSlots() {
        return this.processingOutputSlots;
    }

    public FakeSlot getSmithingTableBaseSlot() {
        return this.smithingTableBaseSlot;
    }

    public FakeSlot getSmithingTableAdditionSlot() {
        return this.smithingTableAdditionSlot;
    }

    public void cycleProcessingOutput() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CYCLE_PROCESSING_OUTPUT);
        } else {
            int i;
            if (this.mode != EncodingMode.PROCESSING) {
                return;
            }
            class_1799[] newOutputs = new class_1799[this.getProcessingOutputSlots().length];
            block0: for (i = 0; i < this.processingOutputSlots.length; ++i) {
                newOutputs[i] = class_1799.field_8037;
                if (this.processingOutputSlots[i].method_7677().method_7960()) continue;
                for (int j = 1; j < this.processingOutputSlots.length; ++j) {
                    class_1799 nextItem = this.processingOutputSlots[(i + j) % this.processingOutputSlots.length].method_7677();
                    if (nextItem.method_7960()) continue;
                    newOutputs[i] = nextItem;
                    continue block0;
                }
            }
            for (i = 0; i < newOutputs.length; ++i) {
                this.processingOutputSlots[i].method_7673(newOutputs[i]);
            }
        }
    }

    public boolean canCycleProcessingOutputs() {
        return this.mode == EncodingMode.PROCESSING && Arrays.stream(this.processingOutputSlots).filter(s -> !s.method_7677().method_7960()).count() > 1L;
    }

    public List<class_3975> getStonecuttingRecipes() {
        return this.stonecuttingRecipes;
    }
}

