/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.PlacementStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5712;

public class FluidPlacementStrategy
implements PlacementStrategy {
    private final class_3218 level;
    private final class_2338 pos;
    private final class_2350 side;
    private final Set<class_3611> blocked = new HashSet<class_3611>();
    private long lastEffect;

    public FluidPlacementStrategy(class_3218 level, class_2338 pos, class_2350 side, class_2586 host) {
        this.level = level;
        this.pos = pos;
        this.side = side;
    }

    @Override
    public void clearBlocked() {
        this.blocked.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long placeInWorld(AEKey f, long amount, Actionable type, boolean placeAsEntity) {
        if (placeAsEntity) return 0L;
        if (!(f instanceof AEFluidKey)) return 0L;
        AEFluidKey fluidKey = (AEFluidKey)f;
        if (amount < 81000L) {
            return 0L;
        }
        class_3611 fluid = fluidKey.getFluid();
        if (this.blocked.contains(fluid)) {
            return 0L;
        }
        if (fluidKey.hasTag()) {
            return 0L;
        }
        class_2680 state = this.level.method_8320(this.pos);
        if (!this.canPlace((class_1937)this.level, state, this.pos, fluid)) {
            this.blocked.add(fluid);
            return 0L;
        }
        if (type != Actionable.MODULATE) return 81000L;
        if (this.level.method_8597().comp_644() && fluid.method_15791(class_3486.field_15517)) {
            this.playEvaporationEffect((class_1937)this.level, this.pos);
            return 81000L;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2402) {
            class_2402 liquidBlockContainer = (class_2402)class_22482;
            if (fluid == class_3612.field_15910) {
                liquidBlockContainer.method_10311((class_1936)this.level, this.pos, state, ((class_3609)fluid).method_15729(false));
                this.playEmptySound((class_1937)this.level, this.pos, fluid);
                return 81000L;
            }
        }
        if (state.method_26188(fluid) && !state.method_26207().method_15797()) {
            this.level.method_22352(this.pos, true);
        }
        if (!this.level.method_8652(this.pos, fluid.method_15785().method_15759(), 11) && !state.method_26227().method_15771()) {
            return 0L;
        }
        this.playEmptySound((class_1937)this.level, this.pos, fluid);
        return 81000L;
    }

    private void playEmptySound(class_1937 level, class_2338 pos, class_3611 fluid) {
        if (this.throttleEffect()) {
            return;
        }
        class_3414 soundEvent = fluid.method_15791(class_3486.field_15518) ? class_3417.field_15010 : class_3417.field_14834;
        level.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
        level.method_43276(class_5712.field_28166, pos, class_5712.class_7397.method_43286(null, null));
    }

    private void playEvaporationEffect(class_1937 level, class_2338 pos) {
        if (this.throttleEffect()) {
            return;
        }
        level.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            level.method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    private boolean canPlace(class_1937 level, class_2680 state, class_2338 pos, class_3611 fluid) {
        class_2402 liquidBlockContainer;
        class_2248 class_22482;
        if (!(fluid instanceof class_3609)) {
            return false;
        }
        if (state == fluid.method_15785().method_15759()) {
            return false;
        }
        return state.method_26215() || state.method_26188(fluid) || (class_22482 = state.method_26204()) instanceof class_2402 && (liquidBlockContainer = (class_2402)class_22482).method_10310((class_1922)level, pos, state, fluid);
    }

    protected final boolean throttleEffect() {
        long now = System.currentTimeMillis();
        if (now < this.lastEffect + 250L) {
            return true;
        }
        this.lastEffect = now;
        return false;
    }
}

