/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.behaviors.PickupStrategy;
import appeng.api.behaviors.PlacementStrategy;
import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackImportStrategy;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.AEKeyFilter;
import appeng.parts.automation.FabricExternalStorageStrategy;
import appeng.parts.automation.FluidPickupStrategy;
import appeng.parts.automation.FluidPlacementStrategy;
import appeng.parts.automation.ItemPickupStrategy;
import appeng.parts.automation.ItemPlacementStrategy;
import appeng.parts.automation.PlacementStrategyFacade;
import appeng.parts.automation.StackExportFacade;
import appeng.parts.automation.StackImportFacade;
import appeng.parts.automation.StorageExportStrategy;
import appeng.parts.automation.StorageImportStrategy;
import appeng.util.CowMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1887;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public final class StackWorldBehaviors {
    private static final CowMap<AEKeyType, StackImportStrategy.Factory> importStrategies = CowMap.identityHashMap();
    private static final CowMap<AEKeyType, StackExportStrategy.Factory> exportStrategies = CowMap.identityHashMap();
    private static final CowMap<AEKeyType, ExternalStorageStrategy.Factory> externalStorageStrategies = CowMap.identityHashMap();
    private static final CowMap<AEKeyType, PlacementStrategy.Factory> placementStrategies = CowMap.identityHashMap();
    private static final CowMap<AEKeyType, PickupStrategy.Factory> pickupStrategies = CowMap.identityHashMap();

    private StackWorldBehaviors() {
    }

    public static void registerImportStrategy(AEKeyType type, StackImportStrategy.Factory factory) {
        importStrategies.putIfAbsent(type, factory);
    }

    public static void registerExportStrategy(AEKeyType type, StackExportStrategy.Factory factory) {
        exportStrategies.putIfAbsent(type, factory);
    }

    public static void registerExternalStorageStrategy(AEKeyType type, ExternalStorageStrategy.Factory factory) {
        externalStorageStrategies.putIfAbsent(type, factory);
    }

    public static void registerPlacementStrategy(AEKeyType type, PlacementStrategy.Factory factory) {
        placementStrategies.putIfAbsent(type, factory);
    }

    public static void registerPickupStrategy(AEKeyType type, PickupStrategy.Factory factory) {
        pickupStrategies.putIfAbsent(type, factory);
    }

    public static AEKeyFilter hasImportStrategyFilter() {
        return what -> importStrategies.getMap().containsKey(what.getType());
    }

    public static AEKeyFilter hasExportStrategyFilter() {
        return what -> exportStrategies.getMap().containsKey(what.getType());
    }

    public static AEKeyFilter hasPlacementStrategy() {
        return what -> placementStrategies.getMap().containsKey(what.getType());
    }

    public static StackImportStrategy createImportFacade(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        ArrayList<StackImportStrategy> strategies = new ArrayList<StackImportStrategy>(importStrategies.getMap().size());
        for (StackImportStrategy.Factory supplier : importStrategies.getMap().values()) {
            strategies.add(supplier.create(level, fromPos, fromSide));
        }
        return new StackImportFacade(strategies);
    }

    public static StackExportStrategy createExportFacade(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        ArrayList<StackExportStrategy> strategies = new ArrayList<StackExportStrategy>(exportStrategies.getMap().size());
        for (StackExportStrategy.Factory supplier : exportStrategies.getMap().values()) {
            strategies.add(supplier.create(level, fromPos, fromSide));
        }
        return new StackExportFacade(strategies);
    }

    public static Map<AEKeyType, ExternalStorageStrategy> createExternalStorageStrategies(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        IdentityHashMap<AEKeyType, ExternalStorageStrategy> strategies = new IdentityHashMap<AEKeyType, ExternalStorageStrategy>(externalStorageStrategies.getMap().size());
        for (Map.Entry<AEKeyType, ExternalStorageStrategy.Factory> entry : externalStorageStrategies.getMap().entrySet()) {
            strategies.put(entry.getKey(), entry.getValue().create(level, fromPos, fromSide));
        }
        return strategies;
    }

    public static PlacementStrategy createPlacementStrategies(class_3218 level, class_2338 fromPos, class_2350 fromSide, class_2586 host) {
        IdentityHashMap<AEKeyType, PlacementStrategy> strategies = new IdentityHashMap<AEKeyType, PlacementStrategy>(placementStrategies.getMap().size());
        for (Map.Entry<AEKeyType, PlacementStrategy.Factory> entry : placementStrategies.getMap().entrySet()) {
            strategies.put(entry.getKey(), entry.getValue().create(level, fromPos, fromSide, host));
        }
        return new PlacementStrategyFacade(strategies);
    }

    public static List<PickupStrategy> createPickupStrategies(class_3218 level, class_2338 fromPos, class_2350 fromSide, class_2586 host, Map<class_1887, Integer> enchantments) {
        return pickupStrategies.getMap().values().stream().map(f -> f.create(level, fromPos, fromSide, host, enchantments)).toList();
    }

    static {
        StackWorldBehaviors.registerImportStrategy(AEKeyType.items(), StorageImportStrategy::createItem);
        StackWorldBehaviors.registerImportStrategy(AEKeyType.fluids(), StorageImportStrategy::createFluid);
        StackWorldBehaviors.registerExportStrategy(AEKeyType.items(), StorageExportStrategy::createItem);
        StackWorldBehaviors.registerExportStrategy(AEKeyType.fluids(), StorageExportStrategy::createFluid);
        StackWorldBehaviors.registerExternalStorageStrategy(AEKeyType.items(), FabricExternalStorageStrategy::createItem);
        StackWorldBehaviors.registerExternalStorageStrategy(AEKeyType.fluids(), FabricExternalStorageStrategy::createFluid);
        StackWorldBehaviors.registerPlacementStrategy(AEKeyType.fluids(), FluidPlacementStrategy::new);
        StackWorldBehaviors.registerPlacementStrategy(AEKeyType.items(), ItemPlacementStrategy::new);
        StackWorldBehaviors.registerPickupStrategy(AEKeyType.fluids(), FluidPickupStrategy::new);
        StackWorldBehaviors.registerPickupStrategy(AEKeyType.items(), ItemPickupStrategy::new);
    }
}

