/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.transform;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class TransformCircumstance {
    public static final TransformCircumstance EXPLOSION = new TransformCircumstance("explosion");
    private final String type;

    public TransformCircumstance(String type) {
        this.type = type;
    }

    static TransformCircumstance fromJson(JsonObject obj) {
        String type = obj.get("type").getAsString();
        if (type.equals("explosion")) {
            return TransformCircumstance.explosion();
        }
        if (type.equals("fluid")) {
            return TransformCircumstance.fluid((class_6862<class_3611>)class_6862.method_40092((class_5321)class_2378.field_25103, (class_2960)new class_2960(obj.get("tag").getAsString())));
        }
        throw new JsonParseException("Invalid transform recipe type " + type);
    }

    static TransformCircumstance fromNetwork(class_2540 buf) {
        String type = buf.method_19772();
        if (type.equals("explosion")) {
            return TransformCircumstance.explosion();
        }
        if (type.equals("fluid")) {
            return TransformCircumstance.fluid((class_6862<class_3611>)class_6862.method_40092((class_5321)class_2378.field_25103, (class_2960)buf.method_10810()));
        }
        throw new DecoderException("Invalid transform recipe type " + type);
    }

    public static TransformCircumstance fluid(class_6862<class_3611> tag) {
        return new FluidType(tag);
    }

    public static TransformCircumstance explosion() {
        return EXPLOSION;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", this.type);
        return obj;
    }

    void toNetwork(class_2540 buf) {
        buf.method_10814(this.type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TransformCircumstance)) return false;
        TransformCircumstance other = (TransformCircumstance)obj;
        if (!this.type.equals(other.type)) return false;
        return true;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean isExplosion() {
        return this.type.equals("explosion");
    }

    public boolean isFluid() {
        return false;
    }

    public boolean isFluid(class_3610 state) {
        return false;
    }

    public boolean isFluid(class_3611 fluid) {
        return false;
    }

    public List<class_3611> getFluidsForRendering() {
        return List.of();
    }

    private static class FluidType
    extends TransformCircumstance {
        public final class_6862<class_3611> fluidTag;

        public FluidType(class_6862<class_3611> fluidTag) {
            super("fluid");
            this.fluidTag = fluidTag;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FluidType)) return false;
            FluidType other = (FluidType)obj;
            if (!Objects.equals(this.fluidTag, other.fluidTag)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.fluidTag);
        }

        @Override
        public JsonObject toJson() {
            JsonObject obj = super.toJson();
            obj.addProperty("tag", this.fluidTag.comp_327().toString());
            return obj;
        }

        @Override
        void toNetwork(class_2540 buf) {
            super.toNetwork(buf);
            buf.method_10812(this.fluidTag.comp_327());
        }

        @Override
        public boolean isFluid() {
            return true;
        }

        @Override
        public boolean isFluid(class_3611 fluid) {
            return fluid.method_15791(this.fluidTag);
        }

        @Override
        public boolean isFluid(class_3610 state) {
            return state.method_15767(this.fluidTag);
        }

        @Override
        public List<class_3611> getFluidsForRendering() {
            return class_2378.field_11154.method_40266(this.fluidTag).map(t -> t.method_40239().map(class_6880::comp_349).toList()).orElse(List.of());
        }
    }
}

