/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.api.networking.pathing.ChannelMode;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.hooks.ticking.TickHandler;
import appeng.me.Grid;
import appeng.server.ISubCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Locale;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public class ChannelModeCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<class_2168> builder) {
        for (ChannelMode mode : ChannelMode.values()) {
            builder.then(class_2170.method_9247((String)mode.name().toLowerCase(Locale.ROOT)).executes(ctx -> {
                this.setChannelMode((CommandContext<class_2168>)ctx, mode);
                return 1;
            }));
        }
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<class_2168> ctx, class_2168 sender) {
        ChannelMode mode = AEConfig.instance().getChannelMode();
        sender.method_9226((class_2561)PlayerMessages.ChannelModeCurrent.text(mode.name().toLowerCase(Locale.ROOT)), true);
    }

    private void setChannelMode(CommandContext<class_2168> ctx, ChannelMode mode) {
        AELog.info("%s is changing channel mode to %s", new Object[]{ctx.getSource(), mode});
        AEConfig.instance().setChannelModel(mode);
        AEConfig.instance().save();
        int gridCount = 0;
        for (Grid grid : TickHandler.instance().getGridList()) {
            grid.getPathingService().repath();
            ++gridCount;
        }
        String modeName = mode.name().toLowerCase(Locale.ROOT);
        ((class_2168)ctx.getSource()).method_9226((class_2561)PlayerMessages.ChannelModeSet.text(modeName, gridCount), true);
    }
}

