/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.items.tools.powered.ColorApplicatorItem;
import appeng.server.ISubCommand;
import appeng.server.testplots.KitOutPlayerEvent;
import appeng.server.testplots.TestPlots;
import appeng.server.testworld.TestWorldGenerator;
import com.google.common.base.Stopwatch;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SetupTestWorldCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<class_2168> builder) {
        for (class_2960 plotId : TestPlots.getPlotIds()) {
            builder.then(class_2170.method_9247((String)plotId.toString()).executes(ctx -> {
                this.setupTestWorld(((class_2168)ctx.getSource()).method_9211(), (class_2168)ctx.getSource(), plotId);
                return 1;
            }));
        }
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<class_2168> ctx, class_2168 sender) {
        this.setupTestWorld(srv, sender, null);
    }

    private void setupTestWorld(MinecraftServer srv, class_2168 sender, @Nullable class_2960 plotId) {
        Stopwatch sw = Stopwatch.createStarted();
        try {
            class_3222 player = sender.method_9207();
            if (!player.method_7337()) {
                sender.method_9213((class_2561)PlayerMessages.TestWorldNotInCreativeMode.text());
                return;
            }
            class_3218 level = srv.method_30002();
            if (!SetupTestWorldCommand.isVoidWorld(level)) {
                sender.method_9213((class_2561)PlayerMessages.TestWorldNotInSuperflatVoid.text());
                return;
            }
            SetupTestWorldCommand.changeGameRules(srv);
            class_2338 origin = new class_2338(0, 60, 0);
            TestWorldGenerator generator = new TestWorldGenerator(level, player, origin, plotId);
            generator.generate();
            player.method_31549().field_7479 = true;
            player.method_7355();
            this.kitOutPlayer(player);
            if (!generator.isWithinBounds(player.method_24515())) {
                class_2338 goodStartPos = generator.getSuitableStartPos();
                player.method_14251(level, (double)goodStartPos.method_10263(), (double)goodStartPos.method_10264(), (double)goodStartPos.method_10260(), 0.0f, 0.0f);
            }
            sender.method_9226((class_2561)PlayerMessages.TestWorldSetupComplete.text(sw), true);
        }
        catch (CommandSyntaxException | RuntimeException e) {
            AELog.error(e);
            sender.method_9213((class_2561)PlayerMessages.TestWorldSetupFailed.text(e));
        }
    }

    private void kitOutPlayer(class_3222 player) {
        class_1661 playerInv = player.method_31548();
        class_1799 fullApplicator = ColorApplicatorItem.createFullColorApplicator();
        if (!playerInv.method_18862(Collections.singleton(AEItems.COLOR_APPLICATOR.method_8389()))) {
            playerInv.method_7398(fullApplicator);
        }
        ((Consumer)KitOutPlayerEvent.EVENT.invoker()).accept(player);
    }

    private static void changeGameRules(MinecraftServer srv) {
        SetupTestWorldCommand.makeAlwaysDaytime(srv);
        SetupTestWorldCommand.disableWeather(srv);
    }

    private static void makeAlwaysDaytime(MinecraftServer srv) {
        ((class_1928.class_4310)srv.method_3767().method_20746(class_1928.field_19396)).method_20758(false, srv);
        srv.method_30002().method_29199(1000L);
    }

    private static void disableWeather(MinecraftServer srv) {
        ((class_1928.class_4310)srv.method_3767().method_20746(class_1928.field_19406)).method_20758(false, srv);
        srv.method_30002().method_27910(9999, 0, false, false);
    }

    private static boolean isVoidWorld(class_3218 level) {
        class_2794 generator = level.method_14178().method_12129();
        if (!(generator instanceof class_2897)) {
            return false;
        }
        class_2897 flatLevelSource = (class_2897)generator;
        return flatLevelSource.method_28545().method_14312().stream().allMatch(l -> l == null || l.method_26215());
    }
}

