/*
 * Decompiled with CFR 0.152.
 */
package appeng.shaded.methvin.watcher;

import appeng.shaded.methvin.watcher.hashing.FileHash;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Objects;

public final class DirectoryChangeEvent {
    private final EventType eventType;
    private final boolean isDirectory;
    private final Path path;
    private final FileHash hash;
    private final int count;
    private final Path rootPath;

    public DirectoryChangeEvent(EventType eventType, boolean bl, Path path, FileHash fileHash, int n, Path path2) {
        this.eventType = eventType;
        this.isDirectory = bl;
        this.hash = fileHash;
        this.path = path;
        this.count = n;
        this.rootPath = path2;
    }

    public EventType eventType() {
        return this.eventType;
    }

    public Path path() {
        return this.path;
    }

    public int count() {
        return this.count;
    }

    public Path rootPath() {
        return this.rootPath;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public FileHash hash() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DirectoryChangeEvent directoryChangeEvent = (DirectoryChangeEvent)object;
        return this.count == directoryChangeEvent.count && this.eventType == directoryChangeEvent.eventType && this.isDirectory == directoryChangeEvent.isDirectory && Objects.equals(this.path, directoryChangeEvent.path) && Objects.equals(this.rootPath, directoryChangeEvent.rootPath) && Objects.equals(this.hash, directoryChangeEvent.hash);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.isDirectory, this.path, this.count, this.rootPath, this.hash});
    }

    public String toString() {
        return "DirectoryChangeEvent{eventType=" + (Object)((Object)this.eventType) + ", isDirectory=" + this.isDirectory + ", path=" + this.path + ", count=" + this.count + ", rootPath=" + this.rootPath + ", hash=" + (this.hash == null ? "(null)" : this.hash) + '}';
    }

    public static enum EventType {
        CREATE(StandardWatchEventKinds.ENTRY_CREATE),
        MODIFY(StandardWatchEventKinds.ENTRY_MODIFY),
        DELETE(StandardWatchEventKinds.ENTRY_DELETE),
        OVERFLOW(StandardWatchEventKinds.OVERFLOW);

        private WatchEvent.Kind<?> kind;

        private EventType(WatchEvent.Kind<?> kind) {
            this.kind = kind;
        }

        public WatchEvent.Kind<?> getWatchEventKind() {
            return this.kind;
        }
    }
}

