/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.api.features.P2PTunnelAttunement;
import appeng.api.features.P2PTunnelAttunementInternal;
import appeng.api.util.AEColor;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ColoredItemDefinition;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.siteexport.OffScreenRenderer;
import appeng.siteexport.SceneExportJob;
import appeng.siteexport.SiteExportScenes;
import appeng.siteexport.SiteExportWriter;
import appeng.siteexport.model.P2PTypeInfo;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_6862;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class SiteExporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ICON_DIMENSION = 128;
    private static volatile SceneExportJob job;

    public static void initialize() {
        WorldRenderEvents.AFTER_SETUP.register(context -> SiteExporter.continueJob(SceneExportJob::render));
        ServerTickEvents.END_SERVER_TICK.register(server -> SiteExporter.continueJob(SceneExportJob::tick));
    }

    public static void export(FabricClientCommandSource source) {
        source.sendFeedback((class_2561)class_2561.method_43470((String)"AE2 Site-Export started"));
        job = null;
        try {
            SiteExporter.startExport(class_310.method_1551(), source);
        }
        catch (Exception e) {
            LOGGER.error("AE2 site export failed.", (Throwable)e);
            source.sendError((class_2561)class_2561.method_43470((String)e.toString()));
        }
    }

    private static void continueJob(JobFunction event) {
        if (job != null) {
            try {
                event.accept(job);
                if (job.isAtEnd()) {
                    job.sendFeedback((class_2561)class_2561.method_43470((String)"AE2 game data exported to ").method_10852((class_2561)class_2561.method_43470((String)"[site-export]").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, "site-export")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to open export folder"))).method_27705(new class_124[]{class_124.field_1073, class_124.field_1060}))));
                    job = null;
                }
            }
            catch (Exception e) {
                LOGGER.error("AE2 site export failed.", (Throwable)e);
                job.sendError((class_2561)class_2561.method_43470((String)e.toString()));
                job = null;
            }
        }
    }

    private static void startExport(class_310 client, FabricClientCommandSource source) throws Exception {
        if (!client.method_1496()) {
            throw new IllegalStateException("Only run this command from single-player.");
        }
        Path outputFolder = Paths.get("site-export", new String[0]).toAbsolutePath();
        if (Files.isDirectory(outputFolder, new LinkOption[0])) {
            MoreFiles.deleteDirectoryContents((Path)outputFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        } else {
            Files.createDirectories(outputFolder, new FileAttribute[0]);
        }
        SiteExportWriter siteExport = new SiteExportWriter();
        HashSet<class_1792> usedVanillaItems = new HashSet<class_1792>();
        SiteExporter.dumpRecipes(client.field_1687.method_8433(), usedVanillaItems, siteExport);
        SiteExporter.dumpP2PTypes(usedVanillaItems, siteExport);
        usedVanillaItems.add(class_1802.field_8251);
        SiteExporter.dumpColoredItems(siteExport);
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (class_1792 item : class_2378.field_11142) {
            if (!SiteExporter.getItemId(item).method_12836().equals("ae2")) continue;
            stacks.add(new class_1799((class_1935)item));
        }
        for (class_1792 usedVanillaItem : usedVanillaItems) {
            stacks.add(new class_1799((class_1935)usedVanillaItem));
        }
        Path assetFolder = outputFolder.resolve("public");
        SiteExporter.processItems(client, siteExport, stacks, assetFolder);
        Path dataFolder = outputFolder.resolve("data");
        Files.createDirectories(dataFolder, new FileAttribute[0]);
        siteExport.write(dataFolder.resolve("game-data.json"));
        job = new SceneExportJob(SiteExportScenes.createScenes(), source, assetFolder);
    }

    private static void dumpP2PTypes(Set<class_1792> usedVanillaItems, SiteExportWriter siteExport) {
        class_1935[] tunnelTypes;
        for (class_1935 tunnelItem : tunnelTypes = new class_1935[]{P2PTunnelAttunement.ME_TUNNEL, P2PTunnelAttunement.ENERGY_TUNNEL, P2PTunnelAttunement.ITEM_TUNNEL, P2PTunnelAttunement.FLUID_TUNNEL, P2PTunnelAttunement.REDSTONE_TUNNEL, P2PTunnelAttunement.LIGHT_TUNNEL}) {
            P2PTypeInfo typeInfo = new P2PTypeInfo();
            typeInfo.tunnelItemId = SiteExporter.getItemId(tunnelItem.method_8389()).toString();
            HashSet items = new HashSet();
            for (Map.Entry<class_6862<class_1792>, class_1792> entry : P2PTunnelAttunementInternal.getTagTunnels().entrySet()) {
                if (entry.getValue() != tunnelItem.method_8389()) continue;
                class_2378.field_11142.method_40286(entry.getKey()).forEach(h -> items.add((class_1792)h.comp_349()));
            }
            items.stream().map(i -> SiteExporter.getItemId(i).toString()).forEach(typeInfo.attunementItemIds::add);
            P2PTunnelAttunementInternal.AttunementInfo attunementInfo = P2PTunnelAttunementInternal.getAttunementInfo(tunnelItem);
            attunementInfo.apis().stream().map(lookup -> lookup.apiClass().getName()).forEach(typeInfo.attunementApiClasses::add);
            usedVanillaItems.addAll(items);
            siteExport.addP2PType(typeInfo);
        }
    }

    private static void dumpColoredItems(SiteExportWriter siteExport) {
        for (ColoredItemDefinition<?> coloredPart : AEParts.COLORED_PARTS) {
            SiteExporter.dumpColoredItem(coloredPart, siteExport);
        }
    }

    private static void dumpColoredItem(ColoredItemDefinition itemDefinition, SiteExportWriter siteExport) {
        Object baseItem = itemDefinition.item(AEColor.TRANSPARENT);
        if (baseItem == null) {
            return;
        }
        for (AEColor color : AEColor.values()) {
            Object coloredItem;
            if (color.dye == null || (coloredItem = itemDefinition.item(color)) == null) continue;
            siteExport.addColoredVersion((class_1792)baseItem, color.dye, (class_1792)coloredItem);
        }
    }

    private static void processItems(class_310 client, SiteExportWriter siteExport, List<class_1799> items, Path assetFolder) throws IOException {
        Path iconsFolder = assetFolder.resolve("icons");
        if (Files.exists(iconsFolder, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)iconsFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        try (OffScreenRenderer itemRenderer = new OffScreenRenderer(128, 128);){
            itemRenderer.setupItemRendering();
            for (class_1799 stack : items) {
                String itemId = SiteExporter.getItemId(stack.method_7909()).toString();
                Path iconPath = iconsFolder.resolve(itemId.replace(':', '/') + ".png");
                Files.createDirectories(iconPath.getParent(), new FileAttribute[0]);
                itemRenderer.captureAsPng(() -> client.method_1480().method_27953(stack, 0, 0), iconPath);
                String absIconUrl = "/" + assetFolder.relativize(iconPath).toString().replace('\\', '/');
                siteExport.addItem(itemId, stack, absIconUrl);
            }
        }
    }

    private static class_2960 getItemId(class_1792 item) {
        return class_2378.field_11142.method_10221((Object)item);
    }

    private static void addVanillaItem(Set<class_1792> items, class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        class_1792 item = stack.method_7909();
        if ("minecraft".equals(class_2378.field_11142.method_10221((Object)item).method_12836())) {
            items.add(item);
        }
    }

    private static void dumpRecipes(class_1863 recipeManager, Set<class_1792> vanillaItems, SiteExportWriter siteExport) {
        for (class_1860 recipe : recipeManager.method_8126()) {
            if (!recipe.method_8114().method_12836().equals("ae2")) continue;
            if (!recipe.method_8110().method_7960()) {
                SiteExporter.addVanillaItem(vanillaItems, recipe.method_8110());
            }
            for (class_1856 ingredient : recipe.method_8117()) {
                for (class_1799 item : ingredient.method_8105()) {
                    SiteExporter.addVanillaItem(vanillaItems, item);
                }
            }
            if (recipe instanceof class_3955) {
                class_3955 craftingRecipe = (class_3955)recipe;
                if (craftingRecipe.method_8118()) continue;
                siteExport.addRecipe(craftingRecipe);
                continue;
            }
            if (recipe instanceof class_1874) {
                class_1874 cookingRecipe = (class_1874)recipe;
                siteExport.addRecipe(cookingRecipe);
                continue;
            }
            if (!(recipe instanceof InscriberRecipe)) continue;
            InscriberRecipe inscriberRecipe = (InscriberRecipe)recipe;
            siteExport.addRecipe(inscriberRecipe);
        }
    }

    @FunctionalInterface
    static interface JobFunction {
        public void accept(SceneExportJob var1) throws Exception;
    }
}

