/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite.debug;

import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import javax.annotation.Nullable;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4538;
import net.minecraft.class_6880;

public class MeteoriteSpawner {
    public PlacedMeteoriteSettings trySpawnMeteoriteAtSuitableHeight(class_4538 level, class_2338 startPos, float coreRadius, CraterType craterType, boolean pureCrater) {
        int stepSize = Math.min(5, (int)Math.ceil(coreRadius) + 1);
        int minY = 10 + stepSize;
        class_2338.class_2339 mutablePos = startPos.method_25503();
        mutablePos.method_10104(class_2350.field_11033, stepSize);
        while (mutablePos.method_10264() > minY) {
            PlacedMeteoriteSettings spawned = this.trySpawnMeteorite(level, (class_2338)mutablePos, coreRadius, craterType, pureCrater);
            if (spawned != null) {
                return spawned;
            }
            mutablePos.method_33098(mutablePos.method_10264() - stepSize);
        }
        return null;
    }

    @Nullable
    public PlacedMeteoriteSettings trySpawnMeteorite(class_4538 level, class_2338 pos, float coreRadius, CraterType craterType, boolean pureCrater) {
        if (!this.areSurroundingsSuitable(level, pos)) {
            return null;
        }
        FalloutMode fallout = FalloutMode.fromBiome((class_6880<class_1959>)level.method_23753(pos));
        boolean craterLake = false;
        return new PlacedMeteoriteSettings(pos, coreRadius, craterType, fallout, pureCrater, craterLake);
    }

    private boolean areSurroundingsSuitable(class_4538 level, class_2338 pos) {
        int realValidBlocks = 0;
        class_2338.class_2339 testPos = new class_2338.class_2339();
        for (int i = pos.method_10263() - 6; i < pos.method_10263() + 6; ++i) {
            testPos.method_33097(i);
            for (int j = pos.method_10264() - 6; j < pos.method_10264() + 6; ++j) {
                testPos.method_33098(j);
                for (int k = pos.method_10260() - 6; k < pos.method_10260() + 6; ++k) {
                    testPos.method_33099(k);
                    class_2248 block = level.method_8320((class_2338)testPos).method_26204();
                    ++realValidBlocks;
                }
            }
        }
        int validBlocks = 0;
        for (int i = pos.method_10263() - 15; i < pos.method_10263() + 15; ++i) {
            testPos.method_33097(i);
            for (int j = pos.method_10264() - 15; j < pos.method_10264() + 15; ++j) {
                testPos.method_33098(j);
                for (int k = pos.method_10260() - 15; k < pos.method_10260() + 15; ++k) {
                    testPos.method_33099(k);
                    ++validBlocks;
                }
            }
        }
        int minBlocks = 200;
        return validBlocks > 200 && realValidBlocks > 80;
    }
}

