/*
 * Decompiled with CFR 0.152.
 */
package com.slomaxonical.architectspalette.blocks;

import com.slomaxonical.architectspalette.ArchitectsPalette;
import java.util.function.Function;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class SunstoneBlock
extends class_2248 {
    public static final class_2758 LIGHT = class_2758.method_11867((String)"light", (int)0, (int)2);
    public Function<class_1937, Integer> lightSupplier;

    public SunstoneBlock(class_4970.class_2251 properties, Function<class_1937, Integer> getLightState) {
        super(properties);
        this.lightSupplier = getLightState;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIGHT});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)LIGHT, (Comparable)this.lightSupplier.apply(context.method_8045()));
    }

    public boolean method_9542(class_2680 state) {
        return true;
    }

    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 rand) {
        Integer lightstate;
        if (!worldIn.field_9236 && !(lightstate = this.lightSupplier.apply((class_1937)worldIn)).equals(state.method_11654((class_2769)LIGHT))) {
            worldIn.method_8652(pos, (class_2680)state.method_11657((class_2769)LIGHT, (Comparable)lightstate), 6);
        }
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        Double chance;
        if (facingState.method_26204() instanceof SunstoneBlock && (chance = Double.valueOf(ArchitectsPalette.CONFIGS.sunstoneSpreadChance())) > 0.0) {
            class_5819 rand = worldIn.method_8409();
            worldIn.method_39279(currentPos, (class_2248)this, (int)(2.0 + Math.floor(rand.method_43058() * 6.0)));
        }
        return super.method_9559(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public static Integer sunstoneLight(class_1937 world) {
        return SunstoneBlock.getLightFromTime(world, 0L);
    }

    public static Integer moonstoneLight(class_1937 world) {
        return SunstoneBlock.getLightFromTime(world, 12000L);
    }

    private static Integer getLightFromTime(class_1937 world, long offset) {
        MinecraftServer s = world.method_8503();
        if (s == null) {
            return 0;
        }
        class_3218 overworld = s.method_3847(class_1937.field_25179);
        if (overworld != null) {
            long time = (overworld.method_8532() + offset) % 24000L;
            if (time >= 12500L && time <= 23500L) {
                return 0;
            }
            if (time >= 3500L && time <= 8500L) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static boolean isSolid(class_2680 state, class_1922 view, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)LIGHT) == 0;
    }

    public static int lightValue(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LIGHT) * 7;
    }
}

