/*
 * Decompiled with CFR 0.152.
 */
package com.slomaxonical.architectspalette.models;

import com.slomaxonical.architectspalette.models.util.SpriteShift;
import java.util.Arrays;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_806;
import net.minecraft.class_809;

@Environment(value=EnvType.CLIENT)
public class SheetMetalModel
extends ForwardingBakedModel {
    private final SpriteShift spriteShift;

    public SheetMetalModel(class_1087 parent, SpriteShift spriteShift) {
        this.wrapped = parent;
        this.spriteShift = spriteShift;
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public class_806 method_4710() {
        return null;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        Data data = new Data();
        SheetMetalModel.initializeData(blockView, pos, state, data);
        context.pushTransform(quad -> {
            class_2350 dir = quad.lightFace();
            int index = data.get(dir);
            if (index != -1) {
                float uShift = this.spriteShift.getUShift();
                float extraShift = this.spriteShift.getVHeight() * (float)index;
                float vShift = this.spriteShift.getVShift() + extraShift;
                for (int vertex = 0; vertex < 4; ++vertex) {
                    float u = quad.spriteU(vertex, 0);
                    float v = quad.spriteV(vertex, 0);
                    quad.sprite(vertex, 0, u + uShift, v + vShift);
                }
            }
            return true;
        });
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    private static void initializeData(class_1920 world, class_2338 pos, class_2680 state, Data data) {
        class_2338.class_2339 checkPos = new class_2338.class_2339();
        for (class_2350 face : class_2350.values()) {
            if (!class_2248.method_9607((class_2680)state, (class_1922)world, (class_2338)pos, (class_2350)face, (class_2338)checkPos.method_25505((class_2382)pos, face)) && !(state.method_26204() instanceof class_2544)) continue;
            int index = 1;
            boolean doShift = false;
            if (world.method_8320((class_2338)checkPos.method_25505((class_2382)pos, SheetMetalModel.getUpDirection(face))).method_27852(state.method_26204())) {
                ++index;
                doShift = true;
            }
            if (world.method_8320((class_2338)checkPos.method_25505((class_2382)pos, SheetMetalModel.getDownDirection(face))).method_27852(state.method_26204())) {
                --index;
                doShift = true;
            }
            if (!doShift) continue;
            data.set(face, index);
        }
    }

    private static class_2350 getUpDirection(class_2350 face) {
        return face.method_10166().method_10179() ? class_2350.field_11036 : class_2350.field_11043;
    }

    private static class_2350 getDownDirection(class_2350 face) {
        return SheetMetalModel.getUpDirection(face).method_10153();
    }

    private static class Data {
        private final int[] indices = new int[6];

        public Data() {
            Arrays.fill(this.indices, -1);
        }

        public void set(class_2350 face, int index) {
            this.indices[face.method_10146()] = index;
        }

        public int get(class_2350 face) {
            return this.indices[face.method_10146()];
        }
    }
}

