/*
 * Decompiled with CFR 0.152.
 */
package me.sargunvohra.mcmods.autoconfig1u.gui;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.sargunvohra.mcmods.autoconfig1u.ConfigData;
import me.sargunvohra.mcmods.autoconfig1u.ConfigManager;
import me.sargunvohra.mcmods.autoconfig1u.annotation.Config;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.sargunvohra.mcmods.autoconfig1u.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ConfigScreenProvider<T extends ConfigData>
implements Supplier<class_437> {
    private static final class_2960 TRANSPARENT_BACKGROUND = new class_2960("cloth-config2:transparent");
    private final ConfigManager<T> manager;
    private final GuiRegistryAccess registry;
    private final class_437 parent;
    private Function<ConfigManager<T>, String> i13nFunction = manager -> String.format("text.autoconfig.%s", manager.getDefinition().name());
    private Function<ConfigBuilder, class_437> buildFunction = ConfigBuilder::build;
    private BiFunction<String, Field, String> optionFunction = (baseI13n, field) -> String.format("%s.option.%s", baseI13n, field.getName());
    private BiFunction<String, String, String> categoryFunction = (baseI13n, categoryName) -> String.format("%s.category.%s", baseI13n, categoryName);

    public ConfigScreenProvider(ConfigManager<T> manager2, GuiRegistryAccess registry, class_437 parent) {
        this.manager = manager2;
        this.registry = registry;
        this.parent = parent;
    }

    @Deprecated
    public void setI13nFunction(Function<ConfigManager<T>, String> i13nFunction) {
        this.i13nFunction = i13nFunction;
    }

    @Deprecated
    public void setBuildFunction(Function<ConfigBuilder, class_437> buildFunction) {
        this.buildFunction = buildFunction;
    }

    @Deprecated
    public void setCategoryFunction(BiFunction<String, String, String> categoryFunction) {
        this.categoryFunction = categoryFunction;
    }

    @Deprecated
    public void setOptionFunction(BiFunction<String, Field, String> optionFunction) {
        this.optionFunction = optionFunction;
    }

    @Override
    public class_437 get() {
        T config = this.manager.getConfig();
        T defaults = this.manager.getSerializer().createDefault();
        String i13n = this.i13nFunction.apply(this.manager);
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(this.parent).setTitle((class_2561)new class_2588(String.format("%s.title", i13n))).setSavingRunnable(this.manager::save);
        Class<T> configClass = this.manager.getConfigClass();
        if (configClass.isAnnotationPresent(Config.Gui.Background.class)) {
            String bg = configClass.getAnnotation(Config.Gui.Background.class).value();
            class_2960 bgId = class_2960.method_12829((String)bg);
            if (TRANSPARENT_BACKGROUND.equals((Object)bgId)) {
                builder.transparentBackground();
            } else {
                builder.setDefaultBackgroundTexture(bgId);
            }
        }
        Map<String, class_2960> categoryBackgrounds = Arrays.stream((Config.Gui.CategoryBackground[])configClass.getAnnotationsByType(Config.Gui.CategoryBackground.class)).collect(Collectors.toMap(Config.Gui.CategoryBackground::category, ann -> new class_2960(ann.background())));
        Arrays.stream(configClass.getDeclaredFields()).collect(Collectors.groupingBy(field -> this.getOrCreateCategoryForField((Field)field, builder, categoryBackgrounds, i13n), LinkedHashMap::new, Collectors.toList())).forEach((key, value) -> value.forEach(field -> {
            String optionI13n = this.optionFunction.apply(i13n, (Field)field);
            this.registry.getAndTransform(optionI13n, (Field)field, config, defaults, this.registry).forEach(arg_0 -> ((ConfigCategory)key).addEntry(arg_0));
        }));
        return this.buildFunction.apply(builder);
    }

    private ConfigCategory getOrCreateCategoryForField(Field field, ConfigBuilder screenBuilder, Map<String, class_2960> backgroundMap, String baseI13n) {
        class_2588 categoryKey;
        String categoryName = "default";
        if (field.isAnnotationPresent(ConfigEntry.Category.class)) {
            categoryName = field.getAnnotation(ConfigEntry.Category.class).value();
        }
        if (!screenBuilder.hasCategory((class_2561)(categoryKey = new class_2588(this.categoryFunction.apply(baseI13n, categoryName))))) {
            ConfigCategory category = screenBuilder.getOrCreateCategory((class_2561)categoryKey);
            if (backgroundMap.containsKey(categoryName)) {
                category.setCategoryBackground(backgroundMap.get(categoryName));
            }
            return category;
        }
        return screenBuilder.getOrCreateCategory((class_2561)categoryKey);
    }
}

