/*
 * Decompiled with CFR 0.152.
 */
package me.sargunvohra.mcmods.autoconfig1u.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class Utils {
    private Utils() {
    }

    public static <V> V constructUnsafely(Class<V> cls) {
        try {
            Constructor<V> constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> V getUnsafely(Field field, Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            return (V)field.get(obj);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> V getUnsafely(Field field, Object obj, V defaultValue) {
        V ret = Utils.getUnsafely(field, obj);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static void setUnsafely(Field field, Object obj, Object newValue) {
        if (obj == null) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(obj, newValue);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new);
    }
}

