/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui_hud.screen;

import com.google.common.collect.Sets;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.client.gui.screen.BetterStatsScreen;
import io.github.thecsdev.betterstats.client.gui_hud.screen.BshsAutoRequest;
import io.github.thecsdev.betterstats.client.gui_hud.widget.BSHudStatWidget;
import io.github.thecsdev.betterstats.client.network.BetterStatsClientNetworkHandler;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TTextureElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.client.registry.TCDCommonsClientRegistry;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.HashSet;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public final class BetterStatsHudScreen
extends TScreen {
    public static final class_2960 HUD_ID = new class_2960(BetterStats.getModID(), "hud");
    protected class_437 parent;
    protected TButtonWidget btn_done;
    protected TButtonWidget btn_accurate;
    protected TTextureElement img_accurate;
    protected final BooleanConsumer confsc_callback = accepted -> {
        BetterStatsClientNetworkHandler.enableBSSProtocol = accepted;
        this.getClient().method_1507((class_437)this);
        this.updateImgAccurate();
    };
    protected final class_2561 confsc_title = TextUtils.translatable((String)"betterstats.hud.accuracy_mode_warning.title", (Object[])new Object[]{BetterStats.getModID()});
    protected final class_2561 confsc_msg = TextUtils.translatable((String)"betterstats.hud.accuracy_mode_warning.message", (Object[])new Object[]{BetterStats.getModID()});
    public int flag_tickChildren = -1;
    public final HashSet<BSHudStatWidget> stat_widgets = Sets.newHashSet();

    @Nullable
    public static BetterStatsHudScreen getInstance() {
        class_437 bshs = (class_437)TCDCommonsClientRegistry.InGameHud_Screens.get(HUD_ID);
        if (bshs instanceof BetterStatsHudScreen) {
            return (BetterStatsHudScreen)bshs;
        }
        return null;
    }

    public static BetterStatsHudScreen getOrCreateInstance(class_437 parent) throws RuntimeException {
        BetterStatsHudScreen bshs = BetterStatsHudScreen.getInstance();
        if (bshs == null) {
            bshs = new BetterStatsHudScreen(null);
            TCDCommonsClientRegistry.InGameHud_Screens.put(HUD_ID, bshs);
        }
        bshs.parent = parent;
        return bshs;
    }

    public BetterStatsHudScreen(class_437 parent) {
        super((class_2561)TextUtils.translatable((String)"betterstats.hud", (Object[])new Object[0]));
        this.parent = parent;
    }

    protected void onClosed() {
        this.getClient().method_1507(this.parent);
        this.flag_tickChildren = 0;
        this.method_25393();
        this.parent = null;
        if (this.findTChildOfType(BSHudStatWidget.class, false) == null) {
            TCDCommonsClientRegistry.InGameHud_Screens.remove(HUD_ID, (Object)this);
        }
        BetterStatsClientNetworkHandler.c2s_sendPrefs();
    }

    public <T extends BSHudStatWidget> T addHudStatWidget(T widget) {
        if (widget == null || this.stat_widgets.contains(widget)) {
            return widget;
        }
        widget.setPosition(this.getTpeWidth() / 2 - widget.getTpeWidth() / 2, this.getTpeHeight() / 2 - 42, false);
        this.addTChild(widget, false);
        return widget;
    }

    public <T extends TElement> boolean addTChild(T child, boolean reposition) {
        if (super.addTChild(child, reposition)) {
            if (child instanceof BSHudStatWidget && !this.stat_widgets.contains(child)) {
                BSHudStatWidget bshsw = (BSHudStatWidget)child;
                this.stat_widgets.add(bshsw);
                bshsw.reCalculateAnchor();
            }
            return true;
        }
        return false;
    }

    public <T extends TElement> boolean removeTChild(T child, boolean reposition) {
        if (super.removeTChild(child, reposition)) {
            if (child instanceof BSHudStatWidget) {
                this.stat_widgets.remove((Object)((BSHudStatWidget)child));
            }
            return true;
        }
        return false;
    }

    protected void updateImgAccurate() {
        if (this.img_accurate != null) {
            if (BetterStatsClientNetworkHandler.enableBSSProtocol) {
                this.img_accurate.setTextureUVs(20, 20, 20, 20);
            } else {
                this.img_accurate.setTextureUVs(20, 0, 20, 20);
            }
        }
    }

    protected void method_25426() {
        this.btn_done = new TButtonWidget(this.getTpeWidth() / 2 - 50, this.getTpeHeight() / 2 - 10, 100, 20, (class_2561)TextUtils.translatable((String)"gui.done", (Object[])new Object[0]), btn -> this.method_25419());
        this.btn_done.setDrawsVanillaButton(true);
        this.addTChild((TElement)this.btn_done);
        class_5250 txt_hint_a = TextUtils.translatable((String)"betterstats.hud.hint.add_widget", (Object[])new Object[0]);
        class_5250 txt_hint_b = TextUtils.translatable((String)"betterstats.hud.hint.del_widget", (Object[])new Object[0]);
        class_5250 txt_hint_c = TextUtils.translatable((String)"betterstats.hud.hint.esc_close", (Object[])new Object[0]);
        class_5250 txt_hint = TextUtils.literal((String)("1. " + txt_hint_a.getString() + "\n2. " + txt_hint_b.getString() + "\n3. " + txt_hint_c.getString()));
        this.btn_done.setTooltip((class_2561)txt_hint);
        this.btn_accurate = new TButtonWidget(this.btn_done.getTpeEndX() + 5, this.btn_done.getTpeY(), 20, 20, null, btn -> {
            if (BetterStatsClientNetworkHandler.enableBSSProtocol) {
                BetterStatsClientNetworkHandler.enableBSSProtocol = false;
            } else if (this.getClient().method_1542()) {
                BetterStatsClientNetworkHandler.enableBSSProtocol = true;
            } else {
                class_410 confsc = new class_410(this.confsc_callback, this.confsc_title, this.confsc_msg);
                this.getClient().method_1507((class_437)confsc);
                return;
            }
            this.updateImgAccurate();
        });
        this.btn_accurate.setDrawsVanillaButton(true);
        this.btn_accurate.setTooltip((class_2561)TextUtils.translatable((String)"betterstats.hud.accuracy_mode_warning.tooltip", (Object[])new Object[0]));
        this.addTChild((TElement)this.btn_accurate);
        this.img_accurate = new TTextureElement(2, 2, 16, 16);
        this.img_accurate.method_25304(this.btn_accurate.method_25305() + 1);
        this.img_accurate.setTexture(BetterStatsScreen.BSS_WIDGETS_TEXTURE, 256, 256);
        this.img_accurate.setTextureUVs(20, 0, 20, 20);
        this.btn_accurate.addTChild((TElement)this.img_accurate, true);
        this.updateImgAccurate();
        this.stat_widgets.remove(null);
        for (BSHudStatWidget entry : this.stat_widgets) {
            this.addTChild(entry, false);
            entry.rePositionToAnchor();
        }
        this.flag_tickChildren = 0;
        this.method_25393();
    }

    public void method_25393() {
        super.method_25393();
        if (this.flag_tickChildren > 0) {
            --this.flag_tickChildren;
        } else if (this.flag_tickChildren == 0) {
            this.tickChildren();
            this.flag_tickChildren = -1;
        }
        BshsAutoRequest.tick();
    }

    public final void tickChildren() {
        this.btn_done.setVisible(this.getClient().field_1755 == this);
        this.btn_accurate.setVisible(this.btn_done.getVisible() && !this.getClient().method_1542() && BetterStatsClientNetworkHandler.serverHasBSS);
        this.forEachChild(child -> {
            child.tick();
            return false;
        }, true);
    }

    public void method_25420(class_4587 matrices) {
        if (this.getClient().field_1755 == this) {
            BetterStatsHudScreen.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)0x50000000);
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float deltaTime) {
        if (this.getClient().field_1755 != null && this.getClient().field_1755 != this) {
            return;
        }
        super.method_25394(matrices, mouseX, mouseY, deltaTime);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.getClient().field_1755 != this) {
            return false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        TElement hovered;
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if ((keyCode == 259 || keyCode == 261) && (hovered = this.getHoveredTChild()) instanceof BSHudStatWidget) {
            this.removeTChild(hovered);
            return true;
        }
        return false;
    }
}

