/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.api.client.features.player.badges.BssClientPlayerBadge_Badgeless;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.features.player.badges.ClientPlayerBadge;
import io.github.thecsdev.tcdcommons.api.features.player.badges.PlayerBadge;
import io.github.thecsdev.tcdcommons.api.features.player.badges.ServerPlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.hooks.TCommonHooks;
import io.github.thecsdev.tcdcommons.api.registry.TCDCommonsRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2617;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3469;
import org.jetbrains.annotations.Nullable;

public final class BSNetworkProfile {
    public final GameProfile gameProfile;
    public final class_3469 stats;
    public final HashSet<class_2960> playerBadgeIds;

    protected BSNetworkProfile(class_3222 player) {
        this(player.method_7334(), (class_3469)player.method_14248());
        if (TCDCommons.getInstance().getConfig().enablePlayerBadges) {
            this.playerBadgeIds.addAll(ServerPlayerBadgeHandler.getBadgeHandler((class_3222)player).getBadges());
        }
    }

    protected BSNetworkProfile(GameProfile profile, class_3469 stats) {
        this.gameProfile = Objects.requireNonNull(profile);
        this.stats = Objects.requireNonNull(stats);
        this.playerBadgeIds = Sets.newHashSet();
    }

    @Environment(value=EnvType.CLIENT)
    public static BSNetworkProfile ofLocalClient() {
        try {
            class_310 c = class_310.method_1551();
            if (c.field_1724 == null) {
                throw new IllegalStateException("MinecraftClient.player is null");
            }
            return new BSNetworkProfile(c.field_1724.method_7334(), c.field_1724.method_3143());
        }
        catch (Throwable t) {
            if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                throw new IllegalStateException("Are you executing this on the server side?; " + t.getMessage());
            }
            throw t;
        }
    }

    public static BSNetworkProfile ofServerPlayer(@Nullable class_3222 player) {
        if (player == null) {
            return BSNetworkProfile.ofNull();
        }
        return new BSNetworkProfile(player);
    }

    public static BSNetworkProfile ofNull() {
        GameProfile gameProfile = new GameProfile(new UUID(0L, 0L), null);
        return new BSNetworkProfile(gameProfile, new class_3469());
    }

    public static BSNetworkProfile ofGameProfile(GameProfile gameProfile) {
        return new BSNetworkProfile(gameProfile, new class_3469());
    }

    public int hashCode() {
        return this.gameProfile.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BSNetworkProfile)) {
            return false;
        }
        BSNetworkProfile o = (BSNetworkProfile)obj;
        return BSNetworkProfile.compareGameProfiles(this.gameProfile, o.gameProfile);
    }

    public static boolean compareGameProfiles(GameProfile gpA, GameProfile gpB) {
        UUID idA = gpA.getId();
        UUID idB = gpB.getId();
        String nameA = gpA.getName();
        String nameB = gpB.getName();
        boolean a = idA != null && idB != null && Objects.equals(idA, idB);
        boolean b = nameA != null && nameB != null && Objects.equals(nameA, nameB);
        return a || b;
    }

    public void writePacket(class_2540 pbb) {
        BSNetworkProfile.writeGameProfile(pbb, this.gameProfile);
        class_2540 statsPbb = new class_2540(Unpooled.buffer());
        new class_2617(TCommonHooks.getStatHandlerStatMap((class_3469)this.stats)).method_11052(statsPbb);
        pbb.writeInt(statsPbb.readableBytes());
        pbb.writeBytes((ByteBuf)statsPbb);
        statsPbb.release();
        this.playerBadgeIds.remove(null);
        class_2960[] badgeArr = this.playerBadgeIds.toArray(new class_2960[0]);
        pbb.writeInt(badgeArr.length);
        for (class_2960 badgeId : badgeArr) {
            pbb.method_10812(badgeId);
        }
    }

    public static BSNetworkProfile readPacket(class_2540 pbb) {
        GameProfile gameProfile = BSNetworkProfile.readGameProfile(pbb);
        if (gameProfile == null) {
            gameProfile = new GameProfile(new UUID(0L, 0L), null);
        }
        int statsPbbSize = pbb.readInt();
        class_2540 statsPbb = new class_2540(pbb.readBytes(statsPbbSize));
        class_3469 stats = new class_3469();
        Object2IntMap statsMap = TCommonHooks.getStatHandlerStatMap((class_3469)stats);
        for (Object2IntMap.Entry sEntry : ((Object2IntMap)new class_2617(statsPbb).method_11273()).object2IntEntrySet()) {
            statsMap.put((Object)((class_3445)sEntry.getKey()), sEntry.getIntValue());
        }
        statsPbb.release();
        BSNetworkProfile newProfile = new BSNetworkProfile(gameProfile, stats);
        int badgeCount = pbb.readInt();
        for (int index = 0; index < badgeCount && pbb.isReadable(); ++index) {
            class_2960 playerBadgeId = pbb.method_10810();
            PlayerBadge playerBadge = (PlayerBadge)TCDCommonsRegistry.PlayerBadges.getOrDefault((Object)playerBadgeId, null);
            if (playerBadge instanceof ClientPlayerBadge) continue;
            newProfile.playerBadgeIds.add(playerBadgeId);
        }
        return newProfile;
    }

    public static void writeGameProfile(class_2540 buf, @Nullable GameProfile gameProfile) {
        if (gameProfile == null) {
            buf.writeBoolean(false);
            buf.writeBoolean(false);
            return;
        }
        UUID uid = gameProfile.getId();
        String una = gameProfile.getName();
        buf.writeBoolean(uid != null);
        if (uid != null) {
            buf.method_10797(uid);
        }
        buf.writeBoolean(una != null);
        if (una != null) {
            buf.method_10814(una);
        }
    }

    @Nullable
    public static GameProfile readGameProfile(class_2540 buf) {
        UUID uid = null;
        String una = null;
        if (buf.readBoolean()) {
            uid = buf.method_10790();
        }
        if (buf.readBoolean()) {
            una = buf.method_19772();
        }
        if (uid == null && una == null) {
            return null;
        }
        return new GameProfile(uid, una);
    }

    public boolean isLocalClient() {
        try {
            return class_310.method_1551().field_1724.method_7334().equals((Object)this.gameProfile);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public String getProfileDisplayName() {
        return BSNetworkProfile.getGameProfileDisplayName(this.gameProfile);
    }

    public static String getGameProfileDisplayName(GameProfile gameProfile) {
        if (gameProfile.getName() != null) {
            return gameProfile.getName();
        }
        return gameProfile.getId().toString();
    }

    public void putAllStats(BSNetworkProfile other) {
        Object2IntMap shMap = TCommonHooks.getStatHandlerStatMap((class_3469)other.stats);
        Object2IntMap sMap = TCommonHooks.getStatHandlerStatMap((class_3469)this.stats);
        sMap.putAll((Map)shMap);
        this.playerBadgeIds.addAll(other.playerBadgeIds);
    }

    public HashSet<PlayerBadge> collectPlayerBadges() {
        BiMap reg = TCDCommonsRegistry.PlayerBadges;
        HashSet<PlayerBadge> set = new HashSet<PlayerBadge>();
        for (class_2960 badgeId : this.playerBadgeIds) {
            PlayerBadge badge = (PlayerBadge)reg.getOrDefault((Object)badgeId, null);
            if (badge == null) continue;
            set.add(badge);
        }
        if (set.size() == 0) {
            set.add((PlayerBadge)BssClientPlayerBadge_Badgeless.instance);
        }
        return set;
    }
}

