/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.network;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.network.BSNetworkProfile;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2617;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3468;
import net.minecraft.class_3469;

public final class BetterStatsNetworkHandler {
    public static final class_2960 S2C_I_HAVE_BSS;
    public static final class_2960 S2C_REQ_PREFS;
    public static final class_2960 C2S_PREFS;
    public static final class_2960 C2S_REQ_STATS;
    public static final class_2960 S2C_STATS;
    private static final Cache<String, PlayerPreferences> PlayerPrefs;

    protected BetterStatsNetworkHandler() {
    }

    public static void init() {
    }

    private static void initNetworkReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)C2S_PREFS, (payload, context) -> {
            class_3222 player = (class_3222)context.getPlayer();
            PlayerPreferences prefs = BetterStatsNetworkHandler.getOrCreatePlayerPrefs(player);
            prefs.betterStatsInstalled = true;
            try {
                prefs.statsHudAccuracyMode = payload.readBoolean();
            }
            catch (Exception e) {
                BetterStats.LOGGER.debug("Failed to handle '" + C2S_PREFS + "' packet; " + e.getMessage());
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)C2S_REQ_STATS, (payload, context) -> {
            try {
                class_3222 player = (class_3222)context.getPlayer();
                class_3324 playerMgr = player.method_5682().method_3760();
                GameProfile gameProfile = BSNetworkProfile.readGameProfile(payload);
                if (gameProfile == null) {
                    BetterStatsNetworkHandler.s2c_stats(player, null);
                    return;
                }
                class_3222 target = null;
                target = gameProfile.getId() != null ? playerMgr.method_14602(gameProfile.getId()) : playerMgr.method_14566(gameProfile.getName());
                BetterStatsNetworkHandler.s2c_stats(player, target);
            }
            catch (Exception e) {
                BetterStats.LOGGER.debug("Failed to handle '" + C2S_REQ_STATS + "' packet; " + e.getMessage());
            }
        });
    }

    private static PlayerPreferences getOrCreatePlayerPrefs(class_3222 player) {
        String uuid = player.method_5845();
        PlayerPreferences get = (PlayerPreferences)PlayerPrefs.getIfPresent((Object)uuid);
        if (get == null) {
            get = new PlayerPreferences();
            PlayerPrefs.put((Object)uuid, (Object)get);
        }
        return get;
    }

    public static void s2c_iHaveBSS(class_3222 player) {
        class_2540 data = new class_2540(Unpooled.EMPTY_BUFFER);
        try {
            player.field_13987.method_14364((class_2596)new class_2658(S2C_I_HAVE_BSS, data));
        }
        catch (Exception e) {
            BetterStats.LOGGER.debug("Failed to send '" + S2C_I_HAVE_BSS + "' packet; " + e.getMessage());
        }
    }

    public static void s2c_requestPrefs(class_3222 player, boolean force) {
        if (!force && PlayerPrefs.getIfPresent((Object)player.method_5845()) != null) {
            return;
        }
        class_2540 data = new class_2540(Unpooled.EMPTY_BUFFER);
        try {
            player.field_13987.method_14364((class_2596)new class_2658(S2C_REQ_PREFS, data));
        }
        catch (Exception e) {
            BetterStats.LOGGER.debug("Failed to send '" + S2C_REQ_PREFS + "' packet; " + e.getMessage());
        }
    }

    public static void s2c_updatePlayerOnItemStat(class_3222 player, class_1792 item, int m, int c, int u, int b, int pu, int d) {
        PlayerPreferences prefs = (PlayerPreferences)PlayerPrefs.getIfPresent((Object)player.method_5845());
        if (prefs == null) {
            BetterStatsNetworkHandler.s2c_requestPrefs(player, false);
            return;
        }
        if (!prefs.betterStatsInstalled || !prefs.statsHudAccuracyMode) {
            return;
        }
        long curr = System.currentTimeMillis();
        if (curr - prefs._lastItemUpdate < 500L) {
            return;
        }
        prefs._lastItemUpdate = curr;
        StatUtils.StatUtilsItemStat iStats = new StatUtils.StatUtilsItemStat((class_3469)player.method_14248(), item);
        Object2IntOpenHashMap object2int = new Object2IntOpenHashMap();
        if (m > 0 && iStats.block != null) {
            object2int.put((Object)class_3468.field_15427.method_14956((Object)iStats.block), iStats.sMined + m);
        }
        if (c > 0) {
            object2int.put((Object)class_3468.field_15370.method_14956((Object)iStats.item), iStats.sCrafted + c);
        }
        if (u > 0) {
            object2int.put((Object)class_3468.field_15372.method_14956((Object)iStats.item), iStats.sUsed + u);
        }
        if (b > 0) {
            object2int.put((Object)class_3468.field_15383.method_14956((Object)iStats.item), iStats.sBroken + b);
        }
        if (pu > 0) {
            object2int.put((Object)class_3468.field_15392.method_14956((Object)iStats.item), iStats.sPickedUp + pu);
        }
        if (d > 0) {
            object2int.put((Object)class_3468.field_15405.method_14956((Object)iStats.item), iStats.sDropped + d);
        }
        class_2617 packet = new class_2617((Object2IntMap)object2int);
        try {
            player.field_13987.method_14364((class_2596)packet);
        }
        catch (Exception e) {
            BetterStats.LOGGER.debug("Failed to send 'StatisticsS2CPacket' packet; " + e.getMessage());
        }
    }

    public static void s2c_updatePlayerOnMobStat(class_3222 player, class_1299<?> entityType, int k, int d) {
        PlayerPreferences prefs = (PlayerPreferences)PlayerPrefs.getIfPresent((Object)player.method_5845());
        if (prefs == null) {
            BetterStatsNetworkHandler.s2c_requestPrefs(player, false);
            return;
        }
        if (!prefs.betterStatsInstalled || !prefs.statsHudAccuracyMode) {
            return;
        }
        long curr = System.currentTimeMillis();
        if (curr - prefs._lastMobUpdate < 500L) {
            return;
        }
        prefs._lastMobUpdate = curr;
        StatUtils.StatUtilsMobStat eStats = new StatUtils.StatUtilsMobStat((class_3469)player.method_14248(), entityType);
        Object2IntOpenHashMap obj2int = new Object2IntOpenHashMap();
        if (k > 0) {
            obj2int.put((Object)class_3468.field_15403.method_14956(entityType), eStats.killed + k);
        }
        if (d > 0) {
            obj2int.put((Object)class_3468.field_15411.method_14956(entityType), eStats.killedBy + d);
        }
        class_2617 packet = new class_2617((Object2IntMap)obj2int);
        try {
            player.field_13987.method_14364((class_2596)packet);
        }
        catch (Exception e) {
            BetterStats.LOGGER.debug("Failed to send 'StatisticsS2CPacket' packet; " + e.getMessage());
        }
    }

    public static void s2c_stats(class_3222 player, class_3222 whoseStatsToSend) {
        BSNetworkProfile bsnp = BSNetworkProfile.ofServerPlayer(whoseStatsToSend);
        class_2540 data = new class_2540(Unpooled.buffer());
        bsnp.writePacket(data);
        class_2658 packet = new class_2658(S2C_STATS, data);
        try {
            player.field_13987.method_14364((class_2596)packet);
        }
        catch (Exception e) {
            BetterStats.LOGGER.debug("Failed to send '" + S2C_STATS + "' packet; " + e.getMessage());
        }
    }

    static {
        String modId = BetterStats.getModID();
        S2C_I_HAVE_BSS = new class_2960(modId, "s2c_bss");
        S2C_REQ_PREFS = new class_2960(modId, "s2c_rp");
        C2S_PREFS = new class_2960(modId, "c2s_p");
        C2S_REQ_STATS = new class_2960(modId, "c2s_rs");
        S2C_STATS = new class_2960(modId, "s2c_s");
        PlayerPrefs = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
        BetterStatsNetworkHandler.initNetworkReceivers();
        PlayerEvent.PLAYER_JOIN.register(player -> BetterStatsNetworkHandler.s2c_iHaveBSS(player));
        PlayerEvent.PLAYER_RESPAWN.register((player, endPortal) -> BetterStatsNetworkHandler.s2c_requestPrefs(player, false));
        PlayerEvent.PLAYER_QUIT.register(player -> PlayerPrefs.invalidate((Object)player.method_5845()));
        EntityEvent.LIVING_DEATH.register((entity, deathSource) -> {
            if (deathSource.method_5529() instanceof class_3222) {
                BetterStatsNetworkHandler.s2c_updatePlayerOnMobStat((class_3222)deathSource.method_5529(), entity.method_5864(), 1, 0);
            }
            if (entity instanceof class_3222 && deathSource.method_5529() != null) {
                BetterStatsNetworkHandler.s2c_updatePlayerOnMobStat((class_3222)entity, deathSource.method_5529().method_5864(), 0, 1);
            }
            return EventResult.pass();
        });
        BlockEvent.BREAK.register((world, blockPos, blockState, player, exp) -> {
            BetterStatsNetworkHandler.s2c_updatePlayerOnItemStat(player, blockState.method_26204().method_8389(), 1, 0, 0, 0, 0, 0);
            return EventResult.pass();
        });
        BlockEvent.PLACE.register((world, blockPos, blockState, entity) -> {
            if (!(entity instanceof class_3222)) {
                return EventResult.pass();
            }
            BetterStatsNetworkHandler.s2c_updatePlayerOnItemStat((class_3222)entity, blockState.method_26204().method_8389(), 0, 0, 1, 0, 0, 0);
            return EventResult.pass();
        });
        PlayerEvent.CRAFT_ITEM.register((player, itemStack, inventory) -> {
            if (!(player instanceof class_3222)) {
                return;
            }
            BetterStatsNetworkHandler.s2c_updatePlayerOnItemStat((class_3222)player, itemStack.method_7909(), 0, 1, 0, 0, 0, 0);
        });
        PlayerEvent.PICKUP_ITEM_POST.register((player, itemEntity, itemStack) -> {
            if (!(player instanceof class_3222)) {
                return;
            }
            int c = itemStack.method_7947();
            BetterStatsNetworkHandler.s2c_updatePlayerOnItemStat((class_3222)player, itemStack.method_7909(), 0, 0, 0, 0, c, 0);
        });
        PlayerEvent.DROP_ITEM.register((player, itemEntity) -> {
            if (!(player instanceof class_3222)) {
                return EventResult.pass();
            }
            int c = itemEntity.method_6983().method_7947();
            BetterStatsNetworkHandler.s2c_updatePlayerOnItemStat((class_3222)player, itemEntity.method_6983().method_7909(), 0, 0, 0, 0, 0, c);
            return EventResult.pass();
        });
    }

    private static class PlayerPreferences {
        public static final short _updateCooldown = 500;
        public long _lastItemUpdate = 0L;
        public long _lastMobUpdate = 0L;
        public boolean betterStatsInstalled = false;
        public boolean statsHudAccuracyMode = false;

        private PlayerPreferences() {
        }
    }
}

