/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.energy;

import earth.terrarium.botarium.api.energy.EnergySnapshot;
import earth.terrarium.botarium.api.energy.StatefulEnergyContainer;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2586;
import team.reborn.energy.api.EnergyStorage;

public class FabricBlockEnergyStorage
extends SnapshotParticipant<EnergySnapshot>
implements EnergyStorage {
    private final StatefulEnergyContainer<class_2586> container;
    private final class_2586 block;

    public FabricBlockEnergyStorage(StatefulEnergyContainer<class_2586> container, class_2586 block) {
        this.container = container;
        this.block = block;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        if (maxAmount <= 0L) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        return this.container.insertEnergy(Math.min(maxAmount, this.container.maxInsert()), false);
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        if (maxAmount <= 0L) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        return this.container.extractEnergy(Math.min(maxAmount, this.container.maxExtract()), false);
    }

    public long getAmount() {
        return this.container.getStoredEnergy();
    }

    public long getCapacity() {
        return this.container.getMaxCapacity();
    }

    public boolean supportsInsertion() {
        return this.container.allowsInsertion();
    }

    public boolean supportsExtraction() {
        return this.container.allowsExtraction();
    }

    protected EnergySnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    protected void readSnapshot(EnergySnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }

    protected void onFinalCommit() {
        this.container.update(this.block);
    }
}

