/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid;

import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.PlatformFluidItemHandler;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import earth.terrarium.botarium.fabric.fluid.FabricFluidHolder;
import earth.terrarium.botarium.fabric.fluid.ItemStackStorage;
import java.util.ArrayList;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;

public record FabricFluidItemHandler(class_1799 stack, ContainerItemContext context, Storage<FluidVariant> storage) implements PlatformFluidItemHandler
{
    public FabricFluidItemHandler(class_1799 stack) {
        this(stack, ItemStackStorage.of(stack));
    }

    public FabricFluidItemHandler(class_1799 stack, ContainerItemContext context) {
        this(stack, context, (Storage<FluidVariant>)((Storage)FluidStorage.ITEM.find(stack, (Object)context)));
    }

    @Override
    public long insertFluid(ItemStackHolder item, FluidHolder fluid, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            FabricFluidHolder fabricFluidHolder = FabricFluidHolder.of(fluid);
            long inserted = this.storage.insert((Object)fabricFluidHolder.toVariant(), fabricFluidHolder.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            item.setStack(this.context.getItemVariant().toStack());
            long l = inserted;
            return l;
        }
    }

    @Override
    public FluidHolder extractFluid(ItemStackHolder item, FluidHolder fluid, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            FabricFluidHolder fabricFluidHolder = FabricFluidHolder.of(fluid);
            long extracted = this.storage.extract((Object)fabricFluidHolder.toVariant(), fabricFluidHolder.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
                item.setStack(this.context.getItemVariant().toStack());
            }
            FluidHolder fluidHolder = extracted == 0L ? FluidHooks.emptyFluid() : FabricFluidHolder.of(fabricFluidHolder.toVariant(), extracted);
            return fluidHolder;
        }
    }

    @Override
    public int getTankAmount() {
        int size = 0;
        for (StorageView ignored : this.storage) {
            ++size;
        }
        return size;
    }

    @Override
    public FluidHolder getFluidInTank(int tank) {
        ArrayList fluids = new ArrayList();
        this.storage.iterator().forEachRemaining(variant -> fluids.add(FabricFluidHolder.of((FluidVariant)variant.getResource(), variant.getAmount())));
        return (FluidHolder)fluids.get(tank);
    }

    @Override
    public long getTankCapacity(int tank) {
        ArrayList fluids = new ArrayList();
        this.storage.iterator().forEachRemaining(fluids::add);
        return ((StorageView)fluids.get(tank)).getCapacity();
    }

    @Override
    public boolean supportsInsertion() {
        return this.insertFluid(new ItemStackHolder(this.stack).copy(), this.getFluidInTank(0), true) > 0L;
    }

    @Override
    public boolean supportsExtraction() {
        return this.extractFluid(new ItemStackHolder(this.stack), this.getFluidInTank(0), true).getFluidAmount() > 0L;
    }
}

