/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.impl.energy;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import earth.terrarium.botarium.util.Updatable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import team.reborn.energy.api.EnergyStorage;

public class FabricItemEnergyContainer<T extends EnergyContainer & Updatable>
extends SnapshotParticipant<EnergySnapshot>
implements EnergyStorage {
    private final ContainerItemContext ctx;
    private final class_1799 stack;
    private final T container;

    public FabricItemEnergyContainer(ContainerItemContext ctx, class_1799 stack, T container) {
        this.ctx = ctx;
        this.stack = stack;
        class_2487 nbt = ctx.getItemVariant().getNbt();
        if (nbt != null) {
            container.deserialize(nbt);
        }
        this.container = container;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long inserted = this.container.insertEnergy(maxAmount, false);
        this.setChanged(transaction);
        return inserted;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long l = this.container.extractEnergy(maxAmount, false);
        this.setChanged(transaction);
        return l;
    }

    public long getAmount() {
        return this.container.getStoredEnergy();
    }

    public long getCapacity() {
        return this.container.getMaxCapacity();
    }

    public void setChanged(TransactionContext transaction) {
        ((Updatable)this.container).update();
        this.ctx.exchange(ItemVariant.of((class_1799)this.stack), this.ctx.getAmount(), transaction);
    }

    protected EnergySnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    protected void readSnapshot(EnergySnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }
}

