/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.impl.fluid.storage;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.impl.fluid.holder.FabricFluidHolder;
import earth.terrarium.botarium.impl.fluid.holder.ManualSyncing;
import earth.terrarium.botarium.impl.fluid.storage.ExtendedFluidContainer;
import earth.terrarium.botarium.impl.fluid.storage.SingleFluidSlot;
import earth.terrarium.botarium.util.Updatable;
import java.util.Iterator;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class FabricBlockFluidContainer<T extends FluidContainer & Updatable>
extends ExtendedFluidContainer
implements Storage<FluidVariant>,
ManualSyncing {
    protected final T container;

    public FabricBlockFluidContainer(T container) {
        this.container = container;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.insertFluid(FabricFluidHolder.of(resource, maxAmount), false);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.extractFluid(FabricFluidHolder.of(resource, maxAmount), false).getFluidAmount();
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        return IntStream.range(0, this.container.getSize()).mapToObj(index -> new SingleFluidSlot(this, index)).map(holder -> holder).iterator();
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    @Override
    public void readSnapshot(FluidSnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }

    @Override
    public void onFinalCommit() {
        ((Updatable)this.container).update();
    }
}

