/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.command.CommandCarryOn;
import tschipp.carryon.config.ConfigLoader;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.networking.clientbound.ClientboundSyncScriptsPacket;
import tschipp.carryon.networking.serverbound.ServerboundCarryKeyPressedPacket;
import tschipp.carryon.platform.Services;

public class CarryOnCommon {
    public static void registerServerPackets() {
        Services.PLATFORM.registerServerboundPacket(Constants.PACKET_ID_KEY_PRESSED, 0, ServerboundCarryKeyPressedPacket.class, ServerboundCarryKeyPressedPacket::toBytes, ServerboundCarryKeyPressedPacket::new, ServerboundCarryKeyPressedPacket::handle);
    }

    public static void registerClientPackets() {
        Services.PLATFORM.registerClientboundPacket(Constants.PACKET_ID_START_RIDING, 1, ClientboundStartRidingPacket.class, ClientboundStartRidingPacket::toBytes, ClientboundStartRidingPacket::new, ClientboundStartRidingPacket::handle);
        Services.PLATFORM.registerClientboundPacket(Constants.PACKET_ID_SYNC_SCRIPTS, 2, ClientboundSyncScriptsPacket.class, ClientboundSyncScriptsPacket::toBytes, ClientboundSyncScriptsPacket::new, ClientboundSyncScriptsPacket::handle);
    }

    public static void registerConfig() {
        ConfigLoader.registerConfig(Constants.COMMON_CONFIG);
        ConfigLoader.registerConfig(Constants.CLIENT_CONFIG);
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        CommandCarryOn.register(dispatcher);
    }

    public static void onCarryTick(class_3222 player) {
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
        if (carry.isCarrying()) {
            String cmd;
            if (carry.getActiveScript().isPresent() && !(cmd = carry.getActiveScript().get().scriptEffects().commandLoop()).isEmpty()) {
                player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), "/execute as " + player.method_7334().getName() + " run " + cmd);
            }
            if (!Constants.COMMON_CONFIG.settings.slownessInCreative && player.method_7337()) {
                return;
            }
            player.method_6092(new class_1293(class_1294.field_5909, 1, CarryOnCommon.potionLevel(carry, player.field_6002), false, false));
            class_1661 inv = player.method_31548();
            inv.field_7545 = carry.getSelected();
        }
    }

    public static boolean onTryBreakBlock(class_1657 player) {
        CarryOnData carry;
        return player == null || Constants.COMMON_CONFIG.settings.hitWhileCarrying || !(carry = CarryOnDataManager.getCarryData(player)).isCarrying();
    }

    public static boolean onAttackedByPlayer(class_1657 player) {
        CarryOnData carry;
        return player == null || Constants.COMMON_CONFIG.settings.hitWhileCarrying || !(carry = CarryOnDataManager.getCarryData(player)).isCarrying();
    }

    public static void onPlayerAttacked(class_1657 player) {
        CarryOnData carry;
        if (Constants.COMMON_CONFIG.settings.dropCarriedWhenHit && !player.field_6002.field_9236 && (carry = CarryOnDataManager.getCarryData(player)).isCarrying()) {
            PlacementHandler.placeCarried((class_3222)player);
        }
    }

    private static int potionLevel(CarryOnData carry, class_1937 level) {
        if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return 1;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            class_1297 entity = carry.getEntity(level);
            int i = (int)(entity.method_17682() * entity.method_17681());
            if (i > 4) {
                i = 4;
            }
            if (!Constants.COMMON_CONFIG.settings.heavyEntities) {
                i = 1;
            }
            return (int)((double)i * Constants.COMMON_CONFIG.settings.entitySlownessMultiplier);
        }
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            String nbt = carry.getNbt().toString();
            int i = nbt.length() / 500;
            if (i > 4) {
                i = 4;
            }
            if (!Constants.COMMON_CONFIG.settings.heavyTiles) {
                i = 1;
            }
            return (int)((double)i * Constants.COMMON_CONFIG.settings.blockSlownessMultiplier);
        }
        return 0;
    }
}

