/*
 * Decompiled with CFR 0.152.
 */
package com.github.reoseah.catwalksinc.block;

import com.github.reoseah.catwalksinc.CIncBlocks;
import com.github.reoseah.catwalksinc.CatwalksInc;
import com.github.reoseah.catwalksinc.block.CatwalkAccess;
import com.github.reoseah.catwalksinc.block.CatwalkHelper;
import com.github.reoseah.catwalksinc.block.CatwalkStairsBlock;
import com.github.reoseah.catwalksinc.block.PaintScrapableBlock;
import com.github.reoseah.catwalksinc.block.Paintable;
import com.github.reoseah.catwalksinc.block.WaterloggableBlock;
import com.github.reoseah.catwalksinc.block.Wrenchable;
import com.github.reoseah.catwalksinc.block.entity.CatwalkBlockEntity;
import com.github.reoseah.catwalksinc.block.state.ElementMode;
import com.github.reoseah.catwalksinc.block.util.WrenchHelper;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public class CatwalkBlock
extends WaterloggableBlock
implements class_2343,
CatwalkAccess,
Wrenchable,
Paintable {
    public static final class_2746 SOUTH_RAIL = class_2741.field_12540;
    public static final class_2746 WEST_RAIL = class_2741.field_12527;
    public static final class_2746 NORTH_RAIL = class_2741.field_12489;
    public static final class_2746 EAST_RAIL = class_2741.field_12487;
    private static final class_265[] OUTLINE_SHAPES = new class_265[16];
    private static final class_265[] COLLISION_SHAPES = new class_265[16];

    public CatwalkBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)SOUTH_RAIL, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)WEST_RAIL, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)NORTH_RAIL, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)EAST_RAIL, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{SOUTH_RAIL, EAST_RAIL, NORTH_RAIL, WEST_RAIL});
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPES[CatwalkBlock.getCollisionIndex(state)];
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return context.method_17785(this.method_8389()) && !context.method_16193() ? class_259.method_1077() : OUTLINE_SHAPES[CatwalkBlock.getCollisionIndex(state)];
    }

    public class_265 method_25959(class_2680 state, class_1922 world, class_2338 pos) {
        return OUTLINE_SHAPES[CatwalkBlock.getCollisionIndex(state)];
    }

    protected static int getCollisionIndex(class_2680 state) {
        return ((Boolean)state.method_11654((class_2769)SOUTH_RAIL) != false ? 1 : 0) | ((Boolean)state.method_11654((class_2769)WEST_RAIL) != false ? 2 : 0) | ((Boolean)state.method_11654((class_2769)NORTH_RAIL) != false ? 4 : 0) | ((Boolean)state.method_11654((class_2769)EAST_RAIL) != false ? 8 : 0);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        Optional<class_2350> stairsFacing;
        class_2338 pos;
        class_1937 world = ctx.method_8045();
        if ((world.method_8320((pos = ctx.method_8037()).method_10084()).method_26215() || world.method_8320(pos.method_10084()).method_27852(class_2246.field_10382)) && (stairsFacing = CatwalkBlock.findStairsUpDirection((class_1936)world, pos)).isPresent()) {
            return (class_2680)((class_2680)this.getMatchingStairs().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910))).method_11657(CatwalkStairsBlock.FACING, (Comparable)stairsFacing.get().method_10153());
        }
        return (class_2680)((class_2680)((class_2680)((class_2680)super.method_9605(ctx).method_11657((class_2769)SOUTH_RAIL, (Comparable)Boolean.valueOf(this.shouldHaveHandrail((class_1936)world, pos, class_2350.field_11035)))).method_11657((class_2769)WEST_RAIL, (Comparable)Boolean.valueOf(this.shouldHaveHandrail((class_1936)world, pos, class_2350.field_11039)))).method_11657((class_2769)NORTH_RAIL, (Comparable)Boolean.valueOf(this.shouldHaveHandrail((class_1936)world, pos, class_2350.field_11043)))).method_11657((class_2769)EAST_RAIL, (Comparable)Boolean.valueOf(this.shouldHaveHandrail((class_1936)world, pos, class_2350.field_11034)));
    }

    protected static Optional<class_2350> findStairsUpDirection(class_1936 world, class_2338 pos) {
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            CatwalkAccess catwalk;
            class_2338 exitPos = pos.method_10084().method_10093(facing);
            class_2680 exitState = world.method_8320(exitPos);
            class_2248 class_22482 = exitState.method_26204();
            if ((!(class_22482 instanceof CatwalkAccess) || !(catwalk = (CatwalkAccess)class_22482).needsCatwalkConnectivity(exitState, (class_1922)world, pos, facing.method_10153())) && !CatwalkHelper.hasBuiltinCatwalksConnectivity(exitState, world, exitPos, facing.method_10153())) continue;
            return Optional.of(facing);
        }
        return Optional.empty();
    }

    protected class_2680 getMatchingStairs() {
        return CIncBlocks.CATWALK_STAIRS.method_9564();
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        super.method_9559(state, direction, newState, world, posFrom, pos);
        if (direction.method_10166().method_10179()) {
            return (class_2680)state.method_11657((class_2769)CatwalkBlock.getHandrailProperty(direction), (Comparable)Boolean.valueOf(this.shouldHaveHandrail(world, pos, direction)));
        }
        return state;
    }

    public static class_2746 getHandrailProperty(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> SOUTH_RAIL;
            case class_2350.field_11039 -> WEST_RAIL;
            case class_2350.field_11043 -> NORTH_RAIL;
            case class_2350.field_11034 -> EAST_RAIL;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public boolean shouldHaveHandrail(class_1936 world, class_2338 pos, class_2350 side) {
        CatwalkBlockEntity catwalk;
        Optional<ElementMode> handrail;
        class_2586 be = world.method_8321(pos);
        if (be instanceof CatwalkBlockEntity && (handrail = (catwalk = (CatwalkBlockEntity)be).getHandrailState(side)).isPresent()) {
            return handrail.get() == ElementMode.ALWAYS;
        }
        class_2338 neighborPos = pos.method_10093(side);
        class_2680 neighbor = world.method_8320(neighborPos);
        class_2248 class_22482 = neighbor.method_26204();
        if (class_22482 instanceof CatwalkAccess) {
            CatwalkAccess accessible = (CatwalkAccess)class_22482;
            return !accessible.needsCatwalkAccess(neighbor, (class_1922)world, neighborPos, side.method_10153());
        }
        return !CatwalkHelper.hasBuiltinCatwalksAccess(neighbor, world, neighborPos, side.method_10153());
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return null;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!(newState.method_26204() instanceof CatwalkBlock)) {
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    @Override
    public boolean needsCatwalkAccess(class_2680 state, class_1922 world, class_2338 pos, class_2350 side) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof CatwalkBlockEntity) {
            CatwalkBlockEntity catwalk = (CatwalkBlockEntity)be;
            return !catwalk.isHandrailForced(side);
        }
        return true;
    }

    @Override
    public boolean needsCatwalkConnectivity(class_2680 state, class_1922 world, class_2338 pos, class_2350 side) {
        return this.needsCatwalkAccess(state, world, pos, side);
    }

    @Override
    public boolean useWrench(class_2680 state, class_1937 world, class_2338 pos, class_2350 side, class_1657 player, class_1268 hand, class_243 hitPos) {
        class_2350 dir = WrenchHelper.getTargetedQuarter(pos, hitPos);
        CatwalkBlockEntity be = (CatwalkBlockEntity)world.method_8321(pos);
        if (be == null) {
            be = new CatwalkBlockEntity(pos, state);
            world.method_8438((class_2586)be);
        }
        world.method_8501(pos, be.useWrench(dir, state, player));
        if (be.canBeRemoved()) {
            world.method_8544(pos);
        }
        return true;
    }

    @Override
    public boolean canPaintBlock(class_1767 color, class_2680 state, class_1922 world, class_2338 pos) {
        class_2248 block = PaintedCatwalkBlock.ofColor(color);
        return block != null;
    }

    @Override
    public void paintBlock(class_1767 color, class_2680 state, class_1936 world, class_2338 pos) {
        class_2248 block = PaintedCatwalkBlock.ofColor(color);
        if (block != null) {
            world.method_8652(pos, (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)NORTH_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_RAIL)))).method_11657((class_2769)SOUTH_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_RAIL)))).method_11657((class_2769)WEST_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)WEST_RAIL)))).method_11657((class_2769)EAST_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)EAST_RAIL)))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED))), 3);
        }
    }

    static {
        class_265 floor = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        class_265 south = class_2248.method_9541((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 west = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
        class_265 north = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        class_265 east = class_2248.method_9541((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 floorColl = class_2248.method_9541((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)1.0, (double)15.5);
        class_265 southColl = class_2248.method_9541((double)0.5, (double)0.0, (double)15.0, (double)15.5, (double)16.0, (double)15.5);
        class_265 westColl = class_2248.method_9541((double)0.5, (double)0.0, (double)0.5, (double)1.0, (double)16.0, (double)15.5);
        class_265 northColl = class_2248.method_9541((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)1.0);
        class_265 eastColl = class_2248.method_9541((double)15.0, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5);
        class_265 sidesCutout = class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), (class_265)class_2248.method_9541((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)13.0, (double)16.0));
        for (int i = 0; i < 16; ++i) {
            class_265 outline = floor;
            class_265 collision = floorColl;
            if ((i & 1) != 0) {
                outline = class_259.method_1084((class_265)outline, (class_265)south);
                collision = class_259.method_1084((class_265)collision, (class_265)southColl);
            }
            if ((i & 2) != 0) {
                outline = class_259.method_1084((class_265)outline, (class_265)west);
                collision = class_259.method_1084((class_265)collision, (class_265)westColl);
            }
            if ((i & 4) != 0) {
                outline = class_259.method_1084((class_265)outline, (class_265)north);
                collision = class_259.method_1084((class_265)collision, (class_265)northColl);
            }
            if ((i & 8) != 0) {
                outline = class_259.method_1084((class_265)outline, (class_265)east);
                collision = class_259.method_1084((class_265)collision, (class_265)eastColl);
            }
            CatwalkBlock.OUTLINE_SHAPES[i] = class_259.method_1072((class_265)outline, (class_265)sidesCutout, (class_247)class_247.field_16886);
            CatwalkBlock.COLLISION_SHAPES[i] = class_259.method_1072((class_265)collision, (class_265)sidesCutout, (class_247)class_247.field_16886);
        }
    }

    public static class PaintedCatwalkBlock
    extends CatwalkBlock
    implements PaintScrapableBlock {
        protected static final Map<class_1767, class_2248> INSTANCES = new EnumMap<class_1767, class_2248>(class_1767.class);
        protected final class_1767 color;

        public PaintedCatwalkBlock(class_1767 color, class_4970.class_2251 settings) {
            super(settings);
            this.color = color;
            INSTANCES.put(color, this);
        }

        public static class_2248 ofColor(class_1767 color) {
            return INSTANCES.get(color);
        }

        public String method_9539() {
            return class_156.method_646((String)"misc", (class_2960)CatwalksInc.id("painted_catwalk"));
        }

        public void method_9568(class_1799 stack, class_1922 world, List<class_2561> tooltip, class_1836 options) {
            super.method_9568(stack, world, tooltip, options);
            tooltip.add((class_2561)class_2561.method_43471((String)("misc.catwalksinc." + this.color.method_15434())).method_27692(class_124.field_1080));
        }

        @Override
        protected class_2680 getMatchingStairs() {
            return CatwalkStairsBlock.PaintedCatwalkStairsBlock.ofColor(this.color).method_9564();
        }

        @Override
        public boolean canPaintBlock(class_1767 color, class_2680 state, class_1922 world, class_2338 pos) {
            return false;
        }

        @Override
        public void scrapPaint(class_2680 state, class_1936 world, class_2338 pos) {
            world.method_8652(pos, (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)CIncBlocks.CATWALK.method_9564().method_11657((class_2769)NORTH_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_RAIL)))).method_11657((class_2769)SOUTH_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_RAIL)))).method_11657((class_2769)WEST_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)WEST_RAIL)))).method_11657((class_2769)EAST_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)EAST_RAIL)))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED))), 3);
        }
    }
}

