/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft;

import dan200.computercraft.core.apis.http.options.Action;
import dan200.computercraft.core.apis.http.options.AddressRule;
import dan200.computercraft.fabric.util.GameInstanceUtils;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.computer.core.ClientComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.recipe.ComputerUpgradeRecipe;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.proxy.ComputerCraftProxyCommon;
import dan200.computercraft.shared.turtle.recipes.TurtleRecipe;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.ImpostorShapelessRecipe;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ComputerCraft {
    public static final String MOD_ID = "computercraft";
    public static int computerSpaceLimit = 1000000;
    public static int floppySpaceLimit = 125000;
    public static int maximumFilesOpen = 128;
    public static boolean disableLua51Features = false;
    public static String defaultComputerSettings = "";
    public static boolean logComputerErrors = true;
    public static boolean commandRequireCreative = true;
    public static int computerThreads = 1;
    public static long maxMainGlobalTime = TimeUnit.MILLISECONDS.toNanos(10L);
    public static long maxMainComputerTime = TimeUnit.MILLISECONDS.toNanos(5L);
    public static boolean httpEnabled = true;
    public static boolean httpWebsocketEnabled = true;
    public static List<AddressRule> httpRules = List.of(AddressRule.parse("$private", null, Action.DENY.toPartial()), AddressRule.parse("*", null, Action.ALLOW.toPartial()));
    public static int httpMaxRequests = 16;
    public static int httpMaxWebsockets = 4;
    public static int httpDownloadBandwidth = 0x2000000;
    public static int httpUploadBandwidth = 0x2000000;
    public static boolean enableCommandBlock = false;
    public static int modemRange = 64;
    public static int modemHighAltitudeRange = 384;
    public static int modemRangeDuringStorm = 64;
    public static int modemHighAltitudeRangeDuringStorm = 384;
    public static int maxNotesPerTick = 8;
    public static MonitorRenderer monitorRenderer = MonitorRenderer.BEST;
    public static int monitorDistance = 65;
    public static long monitorBandwidth = 1000000L;
    public static boolean turtlesNeedFuel = true;
    public static int turtleFuelLimit = 20000;
    public static int advancedTurtleFuelLimit = 100000;
    public static boolean turtlesObeyBlockProtection = true;
    public static boolean turtlesCanPush = true;
    public static int computerTermWidth = 51;
    public static int computerTermHeight = 19;
    public static final int turtleTermWidth = 39;
    public static final int turtleTermHeight = 13;
    public static int pocketTermWidth = 26;
    public static int pocketTermHeight = 20;
    public static int monitorWidth = 8;
    public static int monitorHeight = 6;
    public static final ClientComputerRegistry clientComputerRegistry = new ClientComputerRegistry();
    public static final ServerComputerRegistry serverComputerRegistry = new ServerComputerRegistry();
    public static final Logger log = LogManager.getLogger((String)"computercraft");

    public static void onInitialize() {
        ComputerCraftProxyCommon.init();
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960(MOD_ID, "colour"), ColourableRecipe.SERIALIZER);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960(MOD_ID, "computer_upgrade"), ComputerUpgradeRecipe.SERIALIZER);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960(MOD_ID, "pocket_computer_upgrade"), PocketComputerUpgradeRecipe.SERIALIZER);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960(MOD_ID, "disk"), DiskRecipe.SERIALIZER);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960(MOD_ID, "printout"), PrintoutRecipe.SERIALIZER);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960(MOD_ID, "turtle"), TurtleRecipe.SERIALIZER);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960(MOD_ID, "turtle_upgrade"), TurtleUpgradeRecipe.SERIALIZER);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960(MOD_ID, "impostor_shaped"), ImpostorRecipe.SERIALIZER);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960(MOD_ID, "impostor_shapeless"), ImpostorShapelessRecipe.SERIALIZER);
        class_2378.method_10230((class_2378)class_2378.field_25299, (class_2960)new class_2960(MOD_ID, "block_named"), (Object)BlockNamedEntityLootCondition.TYPE);
        class_2378.method_10230((class_2378)class_2378.field_25299, (class_2960)new class_2960(MOD_ID, "player_creative"), (Object)PlayerCreativeLootCondition.TYPE);
        class_2378.method_10230((class_2378)class_2378.field_25299, (class_2960)new class_2960(MOD_ID, "has_id"), (Object)HasComputerIdLootCondition.TYPE);
        Registry.init();
        GameInstanceUtils.init();
        FabricLoader.getInstance().getModContainer(MOD_ID).ifPresent(modContainer -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960(MOD_ID, "classic"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960(MOD_ID, "overhaul"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        });
    }
}

