/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import com.google.common.primitives.Ints;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.command.text.TableFormatter;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import org.apache.commons.lang3.StringUtils;

public class ClientTableFormatter
implements TableFormatter {
    private static final byte[] COMPUTER_CRAFT_BYTES = "ComputerCraft".getBytes(StandardCharsets.UTF_8);
    public static final ClientTableFormatter INSTANCE = new ClientTableFormatter();
    private static final Int2IntOpenHashMap lastHeights = new Int2IntOpenHashMap();

    private static class_327 renderer() {
        return class_310.method_1551().field_1772;
    }

    @Override
    @Nullable
    public class_2561 getPadding(class_2561 component, int width) {
        int extraWidth = width - this.getWidth(component);
        if (extraWidth <= 0) {
            return null;
        }
        class_327 renderer = ClientTableFormatter.renderer();
        float spaceWidth = renderer.method_1727(" ");
        int spaces = class_3532.method_15375((float)((float)extraWidth / spaceWidth));
        int extra = extraWidth - (int)((float)spaces * spaceWidth);
        return ChatHelpers.coloured(StringUtils.repeat((char)' ', (int)spaces) + StringUtils.repeat((char)'\u02c8', (int)extra), class_124.field_1080);
    }

    @Override
    public int getColumnPadding() {
        return 3;
    }

    @Override
    public int getWidth(class_2561 component) {
        return ClientTableFormatter.renderer().method_27525((class_5348)component);
    }

    @Override
    public void writeLine(int id, class_2561 component) {
        class_310 mc = class_310.method_1551();
        class_338 chat = mc.field_1705.method_1743();
        chat.method_44811(component, this.createMessageSignature(id), class_7591.method_44751());
    }

    @Override
    public int display(TableBuilder table) {
        class_338 chat = class_310.method_1551().field_1705.method_1743();
        int lastHeight = lastHeights.get(table.getId());
        int height = TableFormatter.super.display(table);
        lastHeights.put(table.getId(), height);
        for (int i = height; i < lastHeight; ++i) {
            chat.method_44812(this.createMessageSignature(i + table.getId()));
        }
        return height;
    }

    public class_7469 createMessageSignature(int id) {
        ByteArrayList list = new ByteArrayList();
        list.addElements(0, Ints.toByteArray((int)id));
        list.addElements(list.size(), COMPUTER_CRAFT_BYTES);
        return new class_7469(list.toByteArray());
    }
}

