/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.render.ComputerBorderRenderer;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.util.Colour;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public final class ItemPocketRenderer
extends ItemMapLikeRenderer {
    public static final ItemPocketRenderer INSTANCE = new ItemPocketRenderer();

    private ItemPocketRenderer() {
    }

    @Override
    protected void renderItem(class_4587 transform, class_4597 bufferSource, class_1799 stack, int light) {
        int termHeight;
        int termWidth;
        Terminal terminal;
        ClientComputer computer = ItemPocketComputer.createClientComputer(stack);
        Terminal terminal2 = terminal = computer == null ? null : computer.getTerminal();
        if (terminal == null) {
            termWidth = ComputerCraft.pocketTermWidth;
            termHeight = ComputerCraft.pocketTermHeight;
        } else {
            termWidth = terminal.getWidth();
            termHeight = terminal.getHeight();
        }
        int width = termWidth * 6 + 4;
        int height = termHeight * 9 + 4;
        transform.method_22903();
        transform.method_22907(class_1160.field_20705.method_23214(180.0f));
        transform.method_22907(class_1160.field_20707.method_23214(180.0f));
        transform.method_22905(0.5f, 0.5f, 0.5f);
        float scale = 0.75f / (float)Math.max(width + 24, height + 24 + 8);
        transform.method_23760().method_23761().method_22672(class_1159.method_24019((float)scale, (float)scale, (float)-1.0f));
        transform.method_23760().method_23762().method_23729(-1.0f);
        transform.method_22904(-0.5 * (double)width, -0.5 * (double)height, 0.0);
        ItemPocketComputer item = (ItemPocketComputer)stack.method_7909();
        ComputerFamily family = item.getFamily();
        int frameColour = item.getColour(stack);
        ItemPocketRenderer.renderFrame(transform, bufferSource, family, frameColour, light, width, height);
        int lightColour = ItemPocketComputer.getLightState(stack);
        if (lightColour == -1) {
            lightColour = Colour.BLACK.getHex();
        }
        ItemPocketRenderer.renderLight(transform, bufferSource, lightColour, width, height);
        if (computer != null && terminal != null) {
            FixedWidthFontRenderer.drawTerminal(FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.getBuffer(RenderTypes.ITEM_POCKET_TERMINAL)), 2.0f, 2.0f, terminal, !computer.isColour(), 2.0f, 2.0f, 2.0f, 2.0f);
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.getBuffer(RenderTypes.ITEM_POCKET_TERMINAL)), 0.0f, 0.0f, width, height);
        }
        transform.method_22909();
    }

    private static void renderFrame(class_4587 transform, class_4597 render, ComputerFamily family, int colour, int light, int width, int height) {
        class_2960 texture = colour != -1 ? ComputerBorderRenderer.BACKGROUND_COLOUR : ComputerBorderRenderer.getTexture(family);
        float r = (float)(colour >>> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >>> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        class_4588 buffer = render.getBuffer(RenderTypes.itemPocketBorder(texture));
        ComputerBorderRenderer.render(transform, buffer, 0, 0, 0, light, width, height, true, r, g, b);
    }

    private static void renderLight(class_4587 transform, class_4597 render, int colour, int width, int height) {
        byte r = (byte)(colour >>> 16 & 0xFF);
        byte g = (byte)(colour >>> 8 & 0xFF);
        byte b = (byte)(colour & 0xFF);
        byte[] c = new byte[]{r, g, b, -1};
        class_4588 buffer = render.getBuffer(RenderTypes.ITEM_POCKET_LIGHT);
        FixedWidthFontRenderer.drawQuad(FixedWidthFontRenderer.toVertexConsumer(transform, buffer), width - 16, (float)height + 6.0f, 0.001f, 16.0f, 8.0f, c, 0xF000F0);
    }
}

