/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class TileEntityTurtleRenderer
implements class_827<TileTurtle> {
    private static final class_1091 NORMAL_TURTLE_MODEL = new class_1091("computercraft:turtle_normal", "inventory");
    private static final class_1091 ADVANCED_TURTLE_MODEL = new class_1091("computercraft:turtle_advanced", "inventory");
    private static final class_1091 COLOUR_TURTLE_MODEL = new class_1091("computercraft:turtle_colour", "inventory");
    private static final class_1091 ELF_OVERLAY_MODEL = new class_1091("computercraft:turtle_elf_overlay", "inventory");
    private final class_5819 random = class_5819.method_43047();
    private final class_824 renderer;

    public TileEntityTurtleRenderer(class_5614.class_5615 context) {
        this.renderer = context.method_32139();
    }

    public static class_1091 getTurtleModel(ComputerFamily family, boolean coloured) {
        switch (family) {
            default: {
                return coloured ? COLOUR_TURTLE_MODEL : NORMAL_TURTLE_MODEL;
            }
            case ADVANCED: 
        }
        return coloured ? COLOUR_TURTLE_MODEL : ADVANCED_TURTLE_MODEL;
    }

    public static class_1091 getTurtleOverlayModel(class_2960 overlay, boolean christmas) {
        if (overlay != null) {
            return new class_1091(overlay, "inventory");
        }
        if (christmas) {
            return ELF_OVERLAY_MODEL;
        }
        return null;
    }

    public void render(@Nonnull TileTurtle turtle, float partialTicks, @Nonnull class_4587 transform, @Nonnull class_4597 buffers, int lightmapCoord, int overlayLight) {
        int[] nArray;
        String label = turtle.createProxy().getLabel();
        class_239 hit = this.renderer.field_4350;
        if (label != null && hit.method_17783() == class_239.class_240.field_1332 && turtle.method_11016().equals((Object)((class_3965)hit).method_17777())) {
            class_310 mc = class_310.method_1551();
            class_327 font = mc.field_1772;
            transform.method_22903();
            transform.method_22904(0.5, 1.2, 0.5);
            transform.method_22907(mc.method_1561().method_24197());
            transform.method_22905(-0.025f, -0.025f, 0.025f);
            class_1159 matrix = transform.method_23760().method_23761();
            int opacity = (int)(mc.field_1690.method_19343(0.25f) * 255.0f) << 24;
            float width = (float)(-font.method_1727(label)) / 2.0f;
            font.method_27521(label, width, 0.0f, 0x20FFFFFF, false, matrix, buffers, true, opacity, lightmapCoord);
            font.method_27521(label, width, 0.0f, -1, false, matrix, buffers, false, 0, lightmapCoord);
            transform.method_22909();
        }
        transform.method_22903();
        class_243 offset = turtle.getRenderOffset(partialTicks);
        float yaw = turtle.getRenderYaw(partialTicks);
        transform.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        transform.method_22904(0.5, 0.5, 0.5);
        transform.method_22907(class_1160.field_20705.method_23214(180.0f - yaw));
        if (label != null && (label.equals("Dinnerbone") || label.equals("Grumm"))) {
            transform.method_22905(1.0f, -1.0f, 1.0f);
        }
        transform.method_22904(-0.5, -0.5, -0.5);
        int colour = turtle.getColour();
        ComputerFamily family = turtle.getFamily();
        class_2960 overlay = turtle.getOverlay();
        class_4588 buffer = buffers.getBuffer(class_4722.method_24076());
        class_1091 class_10912 = TileEntityTurtleRenderer.getTurtleModel(family, colour != -1);
        if (colour == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = colour;
        }
        this.renderModel(transform, buffer, lightmapCoord, overlayLight, class_10912, nArray);
        class_1091 overlayModel = TileEntityTurtleRenderer.getTurtleOverlayModel(overlay, HolidayUtil.getCurrentHoliday() == Holiday.CHRISTMAS);
        if (overlayModel != null) {
            this.renderModel(transform, buffer, lightmapCoord, overlayLight, overlayModel, null);
        }
        this.renderUpgrade(transform, buffer, lightmapCoord, overlayLight, turtle, TurtleSide.LEFT, partialTicks);
        this.renderUpgrade(transform, buffer, lightmapCoord, overlayLight, turtle, TurtleSide.RIGHT, partialTicks);
        transform.method_22909();
    }

    private void renderUpgrade(@Nonnull class_4587 transform, @Nonnull class_4588 renderer, int lightmapCoord, int overlayLight, TileTurtle turtle, TurtleSide side, float f) {
        ITurtleUpgrade upgrade = turtle.getUpgrade(side);
        if (upgrade == null) {
            return;
        }
        transform.method_22903();
        float toolAngle = turtle.getToolRenderAngle(side, f);
        transform.method_22904(0.0, 0.5, 0.5);
        transform.method_22907(class_1160.field_20702.method_23214(toolAngle));
        transform.method_22904(0.0, -0.5, -0.5);
        TransformedModel model = upgrade.getModel(turtle.getAccess(), side);
        model.push(transform);
        this.renderModel(transform, renderer, lightmapCoord, overlayLight, model.getModel(), null);
        transform.method_22909();
        transform.method_22909();
    }

    private void renderModel(@Nonnull class_4587 transform, @Nonnull class_4588 renderer, int lightmapCoord, int overlayLight, class_1091 modelLocation, int[] tints) {
        class_1092 modelManager = class_310.method_1551().method_1480().method_4012().method_3303();
        this.renderModel(transform, renderer, lightmapCoord, overlayLight, modelManager.method_4742(modelLocation), tints);
    }

    private void renderModel(@Nonnull class_4587 transform, @Nonnull class_4588 renderer, int lightmapCoord, int overlayLight, class_1087 model, int[] tints) {
        this.random.method_43052(0L);
        TileEntityTurtleRenderer.renderQuads(transform, renderer, lightmapCoord, overlayLight, model.method_4707(null, null, this.random), tints);
        for (class_2350 facing : DirectionUtil.FACINGS) {
            TileEntityTurtleRenderer.renderQuads(transform, renderer, lightmapCoord, overlayLight, model.method_4707(null, facing, this.random), tints);
        }
    }

    private static void renderQuads(@Nonnull class_4587 transform, @Nonnull class_4588 buffer, int lightmapCoord, int overlayLight, List<class_777> quads, int[] tints) {
        class_4587.class_4665 matrix = transform.method_23760();
        for (class_777 bakedquad : quads) {
            int idx;
            int tint = -1;
            if (tints != null && bakedquad.method_3360() && (idx = bakedquad.method_3359()) >= 0 && idx < tints.length) {
                tint = tints[bakedquad.method_3359()];
            }
            float f = (float)(tint >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(tint >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(tint & 0xFF) / 255.0f;
            buffer.method_22920(matrix, bakedquad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, f, f1, f2, new int[]{lightmapCoord, lightmapCoord, lightmapCoord, lightmapCoord}, overlayLight, true);
        }
    }
}

