/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.sound;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_4234;
import org.lwjgl.BufferUtils;

class DfpwmStream
implements class_4234 {
    public static final int SAMPLE_RATE = 48000;
    private static final int PREC = 10;
    private static final int LPF_STRENGTH = 140;
    private static final AudioFormat MONO_16 = new AudioFormat(48000.0f, 16, 1, true, false);
    private final Queue<ByteBuffer> buffers = new ArrayDeque<ByteBuffer>(2);
    private int charge = 0;
    private int strength = 0;
    private int lowPassCharge;
    private boolean previousBit = false;

    DfpwmStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(@Nonnull ByteBuf input) {
        int readable = input.readableBytes();
        ByteBuffer output = ByteBuffer.allocate(readable * 16).order(ByteOrder.nativeOrder());
        for (int i = 0; i < readable; ++i) {
            byte inputByte = input.readByte();
            for (int j = 0; j < 8; ++j) {
                boolean currentBit = (inputByte & 1) != 0;
                int target = currentBit ? 127 : -128;
                int nextCharge = this.charge + (this.strength * (target - this.charge) + 512 >> 10);
                if (nextCharge == this.charge && nextCharge != target) {
                    nextCharge += currentBit ? 1 : -1;
                }
                int z = currentBit == this.previousBit ? 1023 : 0;
                int nextStrength = this.strength;
                if (this.strength != z) {
                    nextStrength += currentBit == this.previousBit ? 1 : -1;
                }
                if (nextStrength < 8) {
                    nextStrength = 8;
                }
                int chargeWithAntijerk = currentBit == this.previousBit ? nextCharge : nextCharge + this.charge + 1 >> 1;
                this.lowPassCharge += (chargeWithAntijerk - this.lowPassCharge) * 140 + 128 >> 8;
                this.charge = nextCharge;
                this.strength = nextStrength;
                this.previousBit = currentBit;
                output.putShort((short)((byte)(this.lowPassCharge & 0xFF) << 8));
                inputByte = (byte)(inputByte >> 1);
            }
        }
        output.flip();
        DfpwmStream dfpwmStream = this;
        synchronized (dfpwmStream) {
            this.buffers.add(output);
        }
    }

    @Nonnull
    public AudioFormat method_19719() {
        return MONO_16;
    }

    @Nonnull
    public synchronized ByteBuffer method_19720(int capacity) {
        ByteBuffer head;
        ByteBuffer result = BufferUtils.createByteBuffer((int)capacity);
        while (result.hasRemaining() && (head = this.buffers.peek()) != null) {
            int toRead = Math.min(head.remaining(), result.remaining());
            result.put(result.position(), head, head.position(), toRead);
            result.position(result.position() + toRead);
            head.position(head.position() + toRead);
            if (head.hasRemaining()) break;
            this.buffers.remove();
        }
        result.flip();
        return result.remaining() == 0 ? null : result;
    }

    public void close() throws IOException {
        this.buffers.clear();
    }

    public boolean isEmpty() {
        return this.buffers.isEmpty();
    }
}

