/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.terminal;

import java.nio.ByteBuffer;

public class TextBuffer {
    private final char[] text;

    public TextBuffer(char c, int length) {
        this.text = new char[length];
        this.fill(c);
    }

    public TextBuffer(String text) {
        this.text = text.toCharArray();
    }

    public int length() {
        return this.text.length;
    }

    public void write(String text) {
        this.write(text, 0);
    }

    public void write(String text, int start) {
        int pos = start;
        start = Math.max(start, 0);
        int end = Math.min(start + text.length(), pos + text.length());
        end = Math.min(end, this.text.length);
        for (int i = start; i < end; ++i) {
            this.text[i] = text.charAt(i - pos);
        }
    }

    public void write(ByteBuffer text, int start) {
        int pos = start;
        start = Math.max(start, 0);
        int length = text.remaining();
        int end = Math.min(start + length, pos + length);
        end = Math.min(end, this.text.length);
        for (int i = start; i < end; ++i) {
            this.text[i] = (char)(text.get(i - pos) & 0xFF);
        }
    }

    public void write(TextBuffer text) {
        int end = Math.min(text.length(), this.text.length);
        for (int i = 0; i < end; ++i) {
            this.text[i] = text.charAt(i);
        }
    }

    public void fill(char c) {
        this.fill(c, 0, this.text.length);
    }

    public void fill(char c, int start, int end) {
        start = Math.max(start, 0);
        end = Math.min(end, this.text.length);
        for (int i = start; i < end; ++i) {
            this.text[i] = c;
        }
    }

    public char charAt(int i) {
        return this.text[i];
    }

    public void setChar(int i, char c) {
        if (i >= 0 && i < this.text.length) {
            this.text[i] = c;
        }
    }

    public String toString() {
        return new String(this.text);
    }
}

