/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.peripheral.modem.wired.BlockWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockWirelessModem;
import dan200.computercraft.shared.peripheral.monitor.BlockMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import java.util.Iterator;
import java.util.Optional;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;

public class BlockModelProvider
extends FabricModelProvider {
    private static final class_4942 MONITOR_BASE = new class_4942(Optional.of(new class_2960("computercraft", "block/monitor_base")), Optional.empty(), new class_4945[]{class_4945.field_23016, class_4945.field_23018, class_4945.field_23015, class_4945.field_23017});
    private static final class_4942 MODEM = new class_4942(Optional.of(new class_2960("computercraft", "block/modem")), Optional.empty(), new class_4945[]{class_4945.field_23016, class_4945.field_23017});

    public BlockModelProvider(FabricDataGenerator dataGenerator) {
        super(dataGenerator);
    }

    public void generateBlockStateModels(class_4910 generators) {
        this.registerComputer(generators, Registry.ModBlocks.COMPUTER_NORMAL);
        this.registerComputer(generators, Registry.ModBlocks.COMPUTER_ADVANCED);
        this.registerComputer(generators, Registry.ModBlocks.COMPUTER_COMMAND);
        this.registerWirelessModem(generators, Registry.ModBlocks.WIRELESS_MODEM_NORMAL);
        this.registerWirelessModem(generators, Registry.ModBlocks.WIRELESS_MODEM_ADVANCED);
        this.registerWiredModems(generators);
        this.registerMonitors(generators, Registry.ModBlocks.MONITOR_NORMAL);
        this.registerMonitors(generators, Registry.ModBlocks.MONITOR_ADVANCED);
        generators.method_25605((class_2248)Registry.ModBlocks.SPEAKER, class_4946.field_23042);
        generators.method_25623((class_2248)Registry.ModBlocks.SPEAKER, class_4941.method_25842((class_2248)Registry.ModBlocks.SPEAKER));
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
    }

    private void registerComputer(class_4910 generators, BlockComputer<?> block) {
        class_4926.class_4928 generator = class_4926.method_25784(BlockComputer.STATE, (class_2769)BlockComputer.FACING);
        for (ComputerState state : BlockComputer.STATE.method_11898()) {
            class_2960 model = class_4943.field_22978.method_25852(class_4941.method_25843(block, (String)("_" + state)), new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866(block, (String)"_side")).method_25868(class_4945.field_23016, class_4944.method_25866(block, (String)("_front" + state.getTexture()))).method_25868(class_4945.field_23015, class_4944.method_25866(block, (String)"_top")), generators.field_22831);
            for (class_2350 facing : BlockComputer.FACING.method_11898()) {
                generator.method_25797((Comparable)((Object)state), (Comparable)facing, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)BlockModelProvider.toYAngle(facing)).method_25828(class_4936.field_22887, (Object)model));
            }
        }
        generators.field_22830.accept(class_4925.method_25769(block).method_25775((class_4926)generator));
        generators.method_25623(block, class_4941.method_25843(block, (String)"_blinking"));
    }

    private void registerWirelessModem(class_4910 generators, BlockWirelessModem block) {
        class_4926.class_4928 generator = class_4926.method_25784((class_2769)BlockWirelessModem.FACING, (class_2769)BlockWirelessModem.ON);
        Iterator iterator = BlockWirelessModem.ON.method_11898().iterator();
        while (iterator.hasNext()) {
            boolean on = (Boolean)iterator.next();
            class_2960 model = this.modemModel(generators, class_4941.method_25843((class_2248)block, (String)(on ? "_on" : "_off")), class_4944.method_25866((class_2248)block, (String)("_face" + (on ? "_on" : ""))));
            for (class_2350 facing : BlockWirelessModem.FACING.method_11898()) {
                generator.method_25797((Comparable)facing, (Comparable)Boolean.valueOf(on), class_4935.method_25824().method_25828(class_4936.field_22885, (Object)BlockModelProvider.toXAngle(facing)).method_25828(class_4936.field_22886, (Object)BlockModelProvider.toYAngle(facing)).method_25828(class_4936.field_22887, (Object)model));
            }
        }
        generators.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)generator));
        generators.method_25623((class_2248)block, class_4941.method_25843((class_2248)block, (String)"_off"));
    }

    private void registerWiredModems(class_4910 generators) {
        BlockWiredModemFull fullBlock = Registry.ModBlocks.WIRED_MODEM_FULL;
        class_4926.class_4928 fullBlockGenerator = class_4926.method_25784((class_2769)BlockWiredModemFull.MODEM_ON, (class_2769)BlockWiredModemFull.PERIPHERAL_ON);
        Iterator iterator = BlockWiredModemFull.MODEM_ON.method_11898().iterator();
        while (iterator.hasNext()) {
            boolean on = (Boolean)iterator.next();
            Iterator iterator2 = BlockWiredModemFull.PERIPHERAL_ON.method_11898().iterator();
            while (iterator2.hasNext()) {
                boolean peripheral = (Boolean)iterator2.next();
                String suffix = (on ? "_on" : "_off") + (peripheral ? "_peripheral" : "");
                class_2960 faceTexture = new class_2960("computercraft", "block/wired_modem_face" + (peripheral ? "_peripheral" : "") + (on ? "_on" : ""));
                class_2960 fullBlockModel = class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)fullBlock, (String)suffix), new class_4944().method_25868(class_4945.field_23010, faceTexture), generators.field_22831);
                fullBlockGenerator.method_25797((Comparable)Boolean.valueOf(on), (Comparable)Boolean.valueOf(peripheral), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)fullBlockModel));
                this.modemModel(generators, new class_2960("computercraft", "block/wired_modem" + suffix), faceTexture);
            }
        }
        generators.field_22830.accept(class_4925.method_25769((class_2248)fullBlock).method_25775((class_4926)fullBlockGenerator));
        generators.method_25623((class_2248)fullBlock, class_4941.method_25843((class_2248)fullBlock, (String)"_off"));
        generators.method_25538((class_1792)Registry.ModItems.WIRED_MODEM, new class_2960("computercraft", "block/wired_modem_off"));
    }

    private class_2960 modemModel(class_4910 generators, class_2960 name, class_2960 texture) {
        return MODEM.method_25852(name, new class_4944().method_25868(class_4945.field_23016, texture).method_25868(class_4945.field_23017, new class_2960("computercraft", "block/modem_back")), generators.field_22831);
    }

    private void registerMonitors(class_4910 generators, BlockMonitor block) {
        this.monitorModel(generators, block, "", 16, 4, 0, 32);
        this.monitorModel(generators, block, "_d", 20, 7, 0, 36);
        this.monitorModel(generators, block, "_l", 19, 4, 1, 33);
        this.monitorModel(generators, block, "_ld", 31, 7, 1, 45);
        this.monitorModel(generators, block, "_lr", 18, 4, 2, 34);
        this.monitorModel(generators, block, "_lrd", 30, 7, 2, 46);
        this.monitorModel(generators, block, "_lru", 24, 5, 2, 40);
        this.monitorModel(generators, block, "_lrud", 27, 6, 2, 43);
        this.monitorModel(generators, block, "_lu", 25, 5, 1, 39);
        this.monitorModel(generators, block, "_lud", 28, 6, 1, 42);
        this.monitorModel(generators, block, "_r", 17, 4, 3, 35);
        this.monitorModel(generators, block, "_rd", 29, 7, 3, 47);
        this.monitorModel(generators, block, "_ru", 23, 5, 3, 41);
        this.monitorModel(generators, block, "_rud", 26, 6, 3, 44);
        this.monitorModel(generators, block, "_u", 22, 5, 0, 38);
        this.monitorModel(generators, block, "_ud", 21, 6, 0, 37);
        class_4926.class_4929 generator = class_4926.method_25785(BlockMonitor.STATE, (class_2769)BlockMonitor.FACING, (class_2769)BlockMonitor.ORIENTATION);
        for (MonitorEdgeState edge : BlockMonitor.STATE.method_11898()) {
            String suffix = edge == MonitorEdgeState.NONE ? "" : "_" + edge.method_15434();
            class_2960 model = class_4941.method_25843((class_2248)block, (String)suffix);
            for (class_2350 facing : BlockMonitor.FACING.method_11898()) {
                for (class_2350 orientation : BlockMonitor.ORIENTATION.method_11898()) {
                    generator.method_25806((Comparable)((Object)edge), (Comparable)facing, (Comparable)orientation, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22885, (Object)BlockModelProvider.toXAngle(orientation)).method_25828(class_4936.field_22886, (Object)BlockModelProvider.toYAngle(facing)));
                }
            }
        }
        generators.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)generator));
        generators.method_25623((class_2248)block, this.monitorModel(generators, block, "_item", 15, 4, 0, 32));
    }

    private class_2960 monitorModel(class_4910 generators, BlockMonitor block, String corners, int front, int side, int top, int back) {
        return MONITOR_BASE.method_25852(class_4941.method_25843((class_2248)block, (String)corners), new class_4944().method_25868(class_4945.field_23016, class_4944.method_25866((class_2248)block, (String)("_" + front))).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)("_" + side))).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)("_" + top))).method_25868(class_4945.field_23017, class_4944.method_25866((class_2248)block, (String)("_" + back))), generators.field_22831);
    }

    private static class_4936.class_4937 toXAngle(class_2350 direction) {
        switch (direction) {
            default: {
                return class_4936.class_4937.field_22890;
            }
            case field_11036: {
                return class_4936.class_4937.field_22893;
            }
            case field_11033: 
        }
        return class_4936.class_4937.field_22891;
    }

    private static class_4936.class_4937 toYAngle(class_2350 direction) {
        switch (direction) {
            default: {
                return class_4936.class_4937.field_22890;
            }
            case field_11035: {
                return class_4936.class_4937.field_22892;
            }
            case field_11034: {
                return class_4936.class_4937.field_22891;
            }
            case field_11039: 
        }
        return class_4936.class_4937.field_22893;
    }
}

