/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import dan200.computercraft.ComputerCraft;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.class_173;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_58;
import net.minecraft.class_60;
import net.minecraft.class_7403;

abstract class LootTableProvider
implements class_2405 {
    private final class_2403 generator;

    LootTableProvider(class_2403 generator) {
        this.generator = generator;
    }

    public void method_10319(@Nonnull class_7403 cache) {
        HashMap<class_2960, class_52> tables = new HashMap<class_2960, class_52>();
        class_58 validation = new class_58(class_173.field_1177, x -> null, tables::get);
        this.registerLoot((id, table) -> {
            if (tables.containsKey(id)) {
                validation.method_360("Duplicate loot tables for " + id);
            }
            tables.put((class_2960)id, (class_52)table);
        });
        tables.forEach((key, value) -> class_60.method_369((class_58)validation, (class_2960)key, (class_52)value));
        Multimap problems = validation.method_361();
        if (!problems.isEmpty()) {
            problems.forEach((child, problem) -> ComputerCraft.log.warn("Found validation problem in " + child + ": " + problem));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        tables.forEach((key, value) -> {
            Path path = this.getPath((class_2960)key);
            try {
                class_2405.method_10320((class_7403)cache, (JsonElement)class_60.method_372((class_52)value), (Path)path);
            }
            catch (IOException e) {
                ComputerCraft.log.error("Couldn't save loot table {}", (Object)path, (Object)e);
            }
        });
    }

    protected abstract void registerLoot(BiConsumer<class_2960, class_52> var1);

    @Nonnull
    public String method_10321() {
        return "LootTables";
    }

    private Path getPath(class_2960 id) {
        return this.generator.method_10313().resolve("data").resolve(id.method_12836()).resolve("loot_tables").resolve(id.method_12832() + ".json");
    }
}

