/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.data.ExtraConventionalItemTags;
import dan200.computercraft.data.RecipeWrapper;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.ImpostorShapelessRecipe;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2456;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

class RecipeGenerator
extends FabricRecipeProvider {
    RecipeGenerator(FabricDataGenerator generator) {
        super(generator);
    }

    protected void generateRecipes(@Nonnull Consumer<class_2444> add) {
        this.basicRecipes(add);
        this.diskColours(add);
        this.pocketUpgrades(add);
        this.turtleUpgrades(add);
        RecipeGenerator.addSpecial(add, PrintoutRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, DiskRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, ColourableRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, TurtleUpgradeRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, PocketComputerUpgradeRecipe.SERIALIZER);
    }

    private void diskColours(@Nonnull Consumer<class_2444> add) {
        for (Colour colour : Colour.VALUES) {
            class_2450.method_10447((class_1935)Registry.ModItems.DISK).method_10446(ConventionalItemTags.REDSTONE_DUSTS).method_10454((class_1935)class_1802.field_8407).method_10454((class_1935)class_1769.method_7803((class_1767)RecipeGenerator.ofColour(colour))).method_10452("computercraft:disk").method_10442("has_drive", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{Registry.ModBlocks.DISK_DRIVE})).method_17972(RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add, x -> x.method_10569("Color", colour.getHex())), new class_2960("computercraft", "disk_" + (colour.ordinal() + 1)));
        }
    }

    private void turtleUpgrades(@Nonnull Consumer<class_2444> add) {
        for (ComputerFamily family : ComputerFamily.values()) {
            class_1799 base = TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null);
            if (base.method_7960()) continue;
            String nameId = family.name().toLowerCase(Locale.ROOT);
            TurtleUpgrades.getVanillaUpgrades().forEach(upgrade -> {
                class_1799 result = TurtleItemFactory.create(-1, null, -1, family, null, upgrade, -1, null);
                class_2447.method_10437((class_1935)result.method_7909()).method_10435(String.format("%s:turtle_%s", "computercraft", nameId)).method_10439("#T").method_10434(Character.valueOf('T'), (class_1935)base.method_7909()).method_10434(Character.valueOf('#'), (class_1935)upgrade.getCraftingItem().method_7909()).method_10429("has_items", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{base.method_7909(), upgrade.getCraftingItem().method_7909()})).method_17972(RecipeWrapper.wrap(ImpostorRecipe.SERIALIZER, add, result.method_7969()), new class_2960("computercraft", String.format("turtle_%s/%s/%s", nameId, upgrade.getUpgradeID().method_12836(), upgrade.getUpgradeID().method_12832())));
            });
        }
    }

    private void pocketUpgrades(@Nonnull Consumer<class_2444> add) {
        for (ComputerFamily family : ComputerFamily.values()) {
            class_1799 base = PocketComputerItemFactory.create(-1, null, -1, family, null);
            if (base.method_7960()) continue;
            String nameId = family.name().toLowerCase(Locale.ROOT);
            PocketUpgrades.getVanillaUpgrades().forEach(upgrade -> {
                class_1799 result = PocketComputerItemFactory.create(-1, null, -1, family, upgrade);
                class_2447.method_10437((class_1935)result.method_7909()).method_10435(String.format("%s:pocket_%s", "computercraft", nameId)).method_10439("#").method_10439("P").method_10434(Character.valueOf('P'), (class_1935)base.method_7909()).method_10434(Character.valueOf('#'), (class_1935)upgrade.getCraftingItem().method_7909()).method_10429("has_items", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{base.method_7909(), upgrade.getCraftingItem().method_7909()})).method_17972(RecipeWrapper.wrap(ImpostorRecipe.SERIALIZER, add, result.method_7969()), new class_2960("computercraft", String.format("pocket_%s/%s/%s", nameId, upgrade.getUpgradeID().method_12836(), upgrade.getUpgradeID().method_12832())));
            });
        }
    }

    private void basicRecipes(@Nonnull Consumer<class_2444> add) {
        class_2447.method_10436((class_1935)Registry.ModItems.CABLE, (int)6).method_10439(" # ").method_10439("#R#").method_10439(" # ").method_10433(Character.valueOf('#'), ExtraConventionalItemTags.STONES).method_10433(Character.valueOf('R'), ConventionalItemTags.REDSTONE_DUSTS).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_modem", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).method_10431(add);
        class_2447.method_10437(Registry.ModBlocks.COMPUTER_NORMAL).method_10439("###").method_10439("#R#").method_10439("#G#").method_10433(Character.valueOf('#'), ExtraConventionalItemTags.STONES).method_10433(Character.valueOf('R'), ConventionalItemTags.REDSTONE_DUSTS).method_10433(Character.valueOf('G'), ConventionalItemTags.GLASS_PANES).method_10429("has_redstone", (class_184)RecipeGenerator.inventoryChange((class_6862<class_1792>)ConventionalItemTags.REDSTONE_DUSTS)).method_10431(add);
        class_2447.method_10437(Registry.ModBlocks.COMPUTER_ADVANCED).method_10439("###").method_10439("#R#").method_10439("#G#").method_10433(Character.valueOf('#'), ConventionalItemTags.GOLD_INGOTS).method_10433(Character.valueOf('R'), ConventionalItemTags.REDSTONE_DUSTS).method_10433(Character.valueOf('G'), ConventionalItemTags.GLASS_PANES).method_10429("has_components", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{class_1802.field_8725, class_1802.field_8695})).method_10431(add);
        class_2447.method_10437(Registry.ModBlocks.COMPUTER_COMMAND).method_10439("###").method_10439("#R#").method_10439("#G#").method_10433(Character.valueOf('#'), ConventionalItemTags.GOLD_INGOTS).method_10434(Character.valueOf('R'), (class_1935)class_2246.field_10525).method_10433(Character.valueOf('G'), ConventionalItemTags.GLASS_PANES).method_10429("has_components", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{class_2246.field_10525})).method_10431(add);
        class_2447.method_10437((class_1935)Registry.ModBlocks.DISK_DRIVE).method_10439("###").method_10439("#R#").method_10439("#R#").method_10433(Character.valueOf('#'), ExtraConventionalItemTags.STONES).method_10433(Character.valueOf('R'), ConventionalItemTags.REDSTONE_DUSTS).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_1935)Registry.ModBlocks.MONITOR_NORMAL).method_10439("###").method_10439("#G#").method_10439("###").method_10433(Character.valueOf('#'), ExtraConventionalItemTags.STONES).method_10433(Character.valueOf('G'), ConventionalItemTags.GLASS_PANES).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10436((class_1935)Registry.ModBlocks.MONITOR_ADVANCED, (int)4).method_10439("###").method_10439("#G#").method_10439("###").method_10433(Character.valueOf('#'), ConventionalItemTags.GOLD_INGOTS).method_10433(Character.valueOf('G'), ConventionalItemTags.GLASS_PANES).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_1935)Registry.ModItems.POCKET_COMPUTER_NORMAL).method_10439("###").method_10439("#A#").method_10439("#G#").method_10433(Character.valueOf('#'), ExtraConventionalItemTags.STONES).method_10434(Character.valueOf('A'), (class_1935)class_1802.field_8463).method_10433(Character.valueOf('G'), ConventionalItemTags.GLASS_PANES).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_apple", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{class_1802.field_8463})).method_10431(add);
        class_2447.method_10437((class_1935)Registry.ModItems.POCKET_COMPUTER_ADVANCED).method_10439("###").method_10439("#A#").method_10439("#G#").method_10433(Character.valueOf('#'), ConventionalItemTags.GOLD_INGOTS).method_10434(Character.valueOf('A'), (class_1935)class_1802.field_8463).method_10433(Character.valueOf('G'), ConventionalItemTags.GLASS_PANES).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_apple", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{class_1802.field_8463})).method_10431(add);
        class_2447.method_10437((class_1935)Registry.ModBlocks.PRINTER).method_10439("###").method_10439("#R#").method_10439("#D#").method_10433(Character.valueOf('#'), ExtraConventionalItemTags.STONES).method_10433(Character.valueOf('R'), ConventionalItemTags.REDSTONE_DUSTS).method_10433(Character.valueOf('D'), ConventionalItemTags.DYES).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_1935)Registry.ModBlocks.SPEAKER).method_10439("###").method_10439("#N#").method_10439("#R#").method_10433(Character.valueOf('#'), ExtraConventionalItemTags.STONES).method_10434(Character.valueOf('N'), (class_1935)class_2246.field_10179).method_10433(Character.valueOf('R'), ConventionalItemTags.REDSTONE_DUSTS).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_1935)Registry.ModItems.WIRED_MODEM).method_10439("###").method_10439("#R#").method_10439("###").method_10433(Character.valueOf('#'), ExtraConventionalItemTags.STONES).method_10433(Character.valueOf('R'), ConventionalItemTags.REDSTONE_DUSTS).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_cable", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{Registry.ModItems.CABLE})).method_10431(add);
        class_2450.method_10447((class_1935)Registry.ModBlocks.WIRED_MODEM_FULL).method_10454((class_1935)Registry.ModItems.WIRED_MODEM).method_10442("has_modem", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).method_17972(add, new class_2960("computercraft", "wired_modem_full_from"));
        class_2450.method_10447((class_1935)Registry.ModItems.WIRED_MODEM).method_10454((class_1935)Registry.ModBlocks.WIRED_MODEM_FULL).method_10442("has_modem", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).method_17972(add, new class_2960("computercraft", "wired_modem_full_to"));
        class_2447.method_10437((class_1935)Registry.ModBlocks.WIRELESS_MODEM_NORMAL).method_10439("###").method_10439("#E#").method_10439("###").method_10433(Character.valueOf('#'), ExtraConventionalItemTags.STONES).method_10433(Character.valueOf('E'), ExtraConventionalItemTags.ENDER_PEARLS).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_1935)Registry.ModBlocks.WIRELESS_MODEM_ADVANCED).method_10439("###").method_10439("#E#").method_10439("###").method_10433(Character.valueOf('#'), ConventionalItemTags.GOLD_INGOTS).method_10434(Character.valueOf('E'), (class_1935)class_1802.field_8449).method_10429("has_computer", (class_184)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_wireless", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{Registry.ModBlocks.WIRELESS_MODEM_NORMAL})).method_10431(add);
        class_2450.method_10447((class_1935)class_1802.field_8575).method_10446(ExtraConventionalItemTags.SKULLS).method_10454((class_1935)Registry.ModItems.MONITOR_NORMAL).method_10442("has_monitor", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{Registry.ModItems.MONITOR_NORMAL})).method_17972(RecipeWrapper.wrap(class_1865.field_9031, add, RecipeGenerator.playerHead("Cloudhunter", "6d074736-b1e9-4378-a99b-bd8777821c9c")), new class_2960("computercraft", "skull_cloudy"));
        class_2450.method_10447((class_1935)class_1802.field_8575).method_10446(ExtraConventionalItemTags.SKULLS).method_10454((class_1935)Registry.ModItems.COMPUTER_NORMAL).method_10442("has_computer", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{Registry.ModItems.COMPUTER_NORMAL})).method_17972(RecipeWrapper.wrap(class_1865.field_9031, add, RecipeGenerator.playerHead("dan200", "f3c8d69b-0776-4512-8434-d1b2165909eb")), new class_2960("computercraft", "skull_dan200"));
        class_2450.method_10447((class_1935)Registry.ModItems.PRINTED_PAGES).method_10449((class_1935)Registry.ModItems.PRINTED_PAGE, 2).method_10454((class_1935)class_1802.field_8276).method_10442("has_printer", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{Registry.ModBlocks.PRINTER})).method_10431(RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add));
        class_2450.method_10447((class_1935)Registry.ModItems.PRINTED_BOOK).method_10454((class_1935)class_1802.field_8745).method_10449((class_1935)Registry.ModItems.PRINTED_PAGE, 1).method_10454((class_1935)class_1802.field_8276).method_10442("has_printer", (class_184)RecipeGenerator.inventoryChange(new class_1935[]{Registry.ModBlocks.PRINTER})).method_10431(RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add));
    }

    private static class_1767 ofColour(Colour colour) {
        return class_1767.method_7791((int)(15 - colour.ordinal()));
    }

    private static class_2066.class_2068 inventoryChange(class_6862<class_1792> stack) {
        return class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975(stack).method_8976()});
    }

    private static class_2066.class_2068 inventoryChange(class_1935 ... stack) {
        return class_2066.class_2068.method_8959((class_1935[])stack);
    }

    private static class_2487 playerHead(String name, String uuid) {
        class_2487 owner = new class_2487();
        owner.method_10582("Name", name);
        owner.method_10582("Id", uuid);
        class_2487 tag = new class_2487();
        tag.method_10566("SkullOwner", (class_2520)owner);
        return tag;
    }

    private static void addSpecial(Consumer<class_2444> add, class_1866<?> special) {
        class_2960 key = class_2378.field_17598.method_10221(special);
        class_2456.method_10476(special).method_10475(add, key.toString());
    }
}

