/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.builder;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import dan200.computercraft.shared.command.Exceptions;
import dan200.computercraft.shared.command.arguments.RepeatArgumentType;
import dan200.computercraft.shared.command.builder.ArgCommand;
import dan200.computercraft.shared.command.builder.CommandNodeBuilder;
import dan200.computercraft.shared.command.builder.HelpingArgumentBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2168;

public class CommandBuilder<S>
implements CommandNodeBuilder<S, Command<S>> {
    private final List<ArgumentBuilder<S, ?>> args = new ArrayList();
    private Predicate<S> requires;

    public static CommandBuilder<class_2168> args() {
        return new CommandBuilder<class_2168>();
    }

    public static CommandBuilder<class_2168> command(String literal) {
        CommandBuilder<class_2168> builder = new CommandBuilder<class_2168>();
        builder.args.add((ArgumentBuilder)HelpingArgumentBuilder.literal((String)literal));
        return builder;
    }

    public CommandBuilder<S> requires(Predicate<S> predicate) {
        this.requires = this.requires == null ? predicate : this.requires.and(predicate);
        return this;
    }

    public CommandBuilder<S> arg(String name, ArgumentType<?> type) {
        this.args.add((ArgumentBuilder<S, ?>)RequiredArgumentBuilder.argument((String)name, type));
        return this;
    }

    public <T> CommandNodeBuilder<S, ArgCommand<S, List<T>>> argManyValue(String name, ArgumentType<T> type, List<T> empty) {
        return this.argMany(name, type, () -> empty);
    }

    public <T> CommandNodeBuilder<S, ArgCommand<S, List<T>>> argManyValue(String name, ArgumentType<T> type, T defaultValue) {
        return this.argManyValue(name, type, (T)Collections.singletonList(defaultValue));
    }

    public <T> CommandNodeBuilder<S, ArgCommand<S, List<T>>> argMany(String name, ArgumentType<T> type, Supplier<List<T>> empty) {
        return this.argMany(name, RepeatArgumentType.some(type, Exceptions.ARGUMENT_EXPECTED), empty);
    }

    public <T> CommandNodeBuilder<S, ArgCommand<S, List<T>>> argManyFlatten(String name, ArgumentType<List<T>> type, Supplier<List<T>> empty) {
        return this.argMany(name, RepeatArgumentType.someFlat(type, Exceptions.ARGUMENT_EXPECTED), empty);
    }

    private <T, U> CommandNodeBuilder<S, ArgCommand<S, List<T>>> argMany(String name, RepeatArgumentType<T, ?> type, Supplier<List<T>> empty) {
        if (this.args.isEmpty()) {
            throw new IllegalStateException("Cannot have empty arg chain builder");
        }
        return command -> {
            ArgumentBuilder<S, ?> tail = this.tail(arg_0 -> CommandBuilder.lambda$argMany$1(command, (Supplier)empty, arg_0));
            ArgumentBuilder moreArg = RequiredArgumentBuilder.argument((String)name, (ArgumentType)type).executes(ctx -> command.run(ctx, CommandBuilder.getList(ctx, name)));
            tail.then(moreArg);
            return this.link(tail);
        };
    }

    private static <T> List<T> getList(CommandContext<?> context, String name) {
        return (List)context.getArgument(name, List.class);
    }

    @Override
    public CommandNode<S> executes(Command<S> command) {
        if (this.args.isEmpty()) {
            throw new IllegalStateException("Cannot have empty arg chain builder");
        }
        return this.link(this.tail(command));
    }

    private ArgumentBuilder<S, ?> tail(Command<S> command) {
        ArgumentBuilder<S, ?> defaultTail = this.args.get(this.args.size() - 1);
        defaultTail.executes(command);
        if (this.requires != null) {
            defaultTail.requires(this.requires);
        }
        return defaultTail;
    }

    private CommandNode<S> link(ArgumentBuilder<S, ?> tail) {
        for (int i = this.args.size() - 2; i >= 0; --i) {
            tail = this.args.get(i).then(tail);
        }
        return tail.build();
    }

    private static /* synthetic */ int lambda$argMany$1(ArgCommand command, Supplier empty, CommandContext ctx) throws CommandSyntaxException {
        return command.run(ctx, (List)empty.get());
    }
}

