/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.ComputerCraftAPIImpl;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.computer.IComputerEnvironment;
import dan200.computercraft.fabric.util.GameInstanceUtils;
import dan200.computercraft.shared.common.ServerTerminal;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ComputerDataClientMessage;
import dan200.computercraft.shared.network.client.ComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.server.MinecraftServer;

public class ServerComputer
extends ServerTerminal
implements IComputer,
IComputerEnvironment {
    private final int instanceID;
    private class_1937 level;
    private class_2338 position;
    private final ComputerFamily family;
    private final Computer computer;
    private class_2487 userData;
    private boolean changed;
    private boolean changedLastFrame;
    private int ticksSincePing;

    public ServerComputer(class_1937 level, int computerID, String label, int instanceID, ComputerFamily family, int terminalWidth, int terminalHeight) {
        super(family != ComputerFamily.NORMAL, terminalWidth, terminalHeight);
        this.instanceID = instanceID;
        this.level = level;
        this.family = family;
        this.computer = new Computer(this, this.getTerminal(), computerID);
        this.computer.setLabel(label);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public void setLevel(class_1937 level) {
        this.level = level;
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public void setPosition(class_2338 pos) {
        this.position = new class_2338((class_2382)pos);
    }

    public IAPIEnvironment getAPIEnvironment() {
        return this.computer.getAPIEnvironment();
    }

    public Computer getComputer() {
        return this.computer;
    }

    @Override
    public void update() {
        super.update();
        this.computer.tick();
        this.changedLastFrame = this.computer.pollAndResetChanged() || this.changed;
        this.changed = false;
        ++this.ticksSincePing;
    }

    public void keepAlive() {
        this.ticksSincePing = 0;
    }

    public boolean hasTimedOut() {
        return this.ticksSincePing > 100;
    }

    public boolean hasOutputChanged() {
        return this.changedLastFrame;
    }

    public void unload() {
        this.computer.unload();
    }

    public class_2487 getUserData() {
        if (this.userData == null) {
            this.userData = new class_2487();
        }
        return this.userData;
    }

    public void updateUserData() {
        this.changed = true;
    }

    private NetworkMessage createComputerPacket() {
        return new ComputerDataClientMessage(this);
    }

    protected NetworkMessage createTerminalPacket() {
        return new ComputerTerminalClientMessage(this.getInstanceID(), this.write());
    }

    public void broadcastState(boolean force) {
        if (this.hasOutputChanged() || force) {
            NetworkHandler.sendToAllPlayers(this.createComputerPacket());
        }
        if (this.hasTerminalChanged() || force) {
            MinecraftServer server = GameInstanceUtils.getServer();
            NetworkMessage packet = null;
            for (class_1657 player : server.method_3760().method_14571()) {
                if (!this.isInteracting(player)) continue;
                if (packet == null) {
                    packet = this.createTerminalPacket();
                }
                NetworkHandler.sendToPlayer(player, packet);
            }
        }
    }

    public void sendComputerState(class_1657 player) {
        NetworkHandler.sendToPlayer(player, this.createComputerPacket());
    }

    public void sendTerminalState(class_1657 player) {
        NetworkHandler.sendToPlayer(player, this.createTerminalPacket());
    }

    public void broadcastDelete() {
        NetworkHandler.sendToAllPlayers(new ComputerDeletedClientMessage(this.getInstanceID()));
    }

    public void setID(int id) {
        this.computer.setID(id);
    }

    @Override
    public int getInstanceID() {
        return this.instanceID;
    }

    public int getID() {
        return this.computer.getID();
    }

    public String getLabel() {
        return this.computer.getLabel();
    }

    @Override
    public boolean isOn() {
        return this.computer.isOn();
    }

    @Override
    public boolean isCursorDisplayed() {
        return this.computer.isOn() && this.computer.isBlinking();
    }

    @Override
    public void turnOn() {
        this.computer.turnOn();
    }

    @Override
    public void shutdown() {
        this.computer.shutdown();
    }

    @Override
    public void reboot() {
        this.computer.reboot();
    }

    @Override
    public void queueEvent(String event, Object[] arguments) {
        this.computer.queueEvent(event, arguments);
    }

    public int getRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalRedstoneOutput(side);
    }

    public void setRedstoneInput(ComputerSide side, int level) {
        this.computer.getEnvironment().setRedstoneInput(side, level);
    }

    public int getBundledRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalBundledRedstoneOutput(side);
    }

    public void setBundledRedstoneInput(ComputerSide side, int combination) {
        this.computer.getEnvironment().setBundledRedstoneInput(side, combination);
    }

    public void addAPI(ILuaAPI api) {
        this.computer.addApi(api);
    }

    public void setPeripheral(ComputerSide side, IPeripheral peripheral) {
        this.computer.getEnvironment().setPeripheral(side, peripheral);
    }

    public IPeripheral getPeripheral(ComputerSide side) {
        return this.computer.getEnvironment().getPeripheral(side);
    }

    public void setLabel(String label) {
        this.computer.setLabel(label);
    }

    @Override
    public double getTimeOfDay() {
        return (double)((this.level.method_8532() + 6000L) % 24000L) / 1000.0;
    }

    @Override
    public int getDay() {
        return (int)((this.level.method_8532() + 6000L) / 24000L) + 1;
    }

    @Override
    public IWritableMount createSaveDirMount(String subPath, long capacity) {
        return ComputerCraftAPI.createSaveDirMount(this.level, subPath, capacity);
    }

    @Override
    public IMount createResourceMount(String domain, String subPath) {
        return ComputerCraftAPI.createResourceMount(domain, subPath);
    }

    @Override
    public InputStream createResourceFile(String domain, String subPath) {
        return ComputerCraftAPIImpl.getResourceFile(domain, subPath);
    }

    @Override
    public long getComputerSpaceLimit() {
        return ComputerCraft.computerSpaceLimit;
    }

    @Override
    @Nonnull
    public String getHostString() {
        return String.format("ComputerCraft %s (Minecraft %s)", ComputerCraftAPI.getInstalledVersion(), class_155.method_16673().getName());
    }

    @Override
    @Nonnull
    public String getUserAgent() {
        return "computercraft/" + ComputerCraftAPI.getInstalledVersion();
    }

    @Override
    public int assignNewID() {
        return ComputerCraftAPI.createUniqueNumberedSaveDir(this.level, "computer");
    }

    @Nullable
    public IContainerComputer getContainer(class_1657 player) {
        if (player == null) {
            return null;
        }
        class_1703 container = player.field_7512;
        if (!(container instanceof IContainerComputer)) {
            return null;
        }
        IContainerComputer computerContainer = (IContainerComputer)container;
        return computerContainer.getComputer() != this ? null : computerContainer;
    }

    protected boolean isInteracting(class_1657 player) {
        return this.getContainer(player) != null;
    }
}

