/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import dan200.computercraft.core.filesystem.FileSystemWrapper;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.InputState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.upload.FileSlice;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public abstract class ContainerComputerBase
extends class_1703
implements IContainerComputer {
    private static final String LIST_PREFIX = "\n \u2022 ";
    private final Predicate<class_1657> canUse;
    private final IComputer computer;
    private final ComputerFamily family;
    private final InputState input = new InputState(this);
    private UUID toUploadId;
    private List<FileUpload> toUpload;

    public ContainerComputerBase(class_3917<? extends ContainerComputerBase> type, int id, Predicate<class_1657> canUse, IComputer computer, ComputerFamily family) {
        super(type, id);
        this.canUse = canUse;
        this.computer = computer;
        this.family = family;
    }

    public ContainerComputerBase(class_3917<? extends ContainerComputerBase> type, int id, class_1661 player, ComputerContainerData data) {
        this(type, id, x -> true, ContainerComputerBase.getComputer(player, data), data.getFamily());
    }

    protected static IComputer getComputer(class_1661 player, ComputerContainerData data) {
        int id = data.getInstanceId();
        if (!player.field_7546.field_6002.field_9236) {
            return ComputerCraft.serverComputerRegistry.get(id);
        }
        ClientComputer computer = (ClientComputer)ComputerCraft.clientComputerRegistry.get(id);
        if (computer == null) {
            computer = new ClientComputer(id);
            ComputerCraft.clientComputerRegistry.add(id, computer);
        }
        return computer;
    }

    public boolean method_7597(@Nonnull class_1657 player) {
        return this.canUse.test(player);
    }

    @Nonnull
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    @Nullable
    public IComputer getComputer() {
        return this.computer;
    }

    @Override
    @Nonnull
    public InputState getInput() {
        return this.input;
    }

    @Override
    public void startUpload(@Nonnull UUID uuid, @Nonnull List<FileUpload> files) {
        this.toUploadId = uuid;
        this.toUpload = files;
    }

    @Override
    public void continueUpload(@Nonnull UUID uploadId, @Nonnull List<FileSlice> slices) {
        if (this.toUploadId == null || this.toUpload == null || !this.toUploadId.equals(uploadId)) {
            ComputerCraft.log.warn("Invalid continueUpload call, skipping.");
            return;
        }
        for (FileSlice slice : slices) {
            slice.apply(this.toUpload);
        }
    }

    @Override
    public void finishUpload(@Nonnull class_3222 uploader, @Nonnull UUID uploadId) {
        if (this.toUploadId == null || this.toUpload == null || this.toUpload.isEmpty() || !this.toUploadId.equals(uploadId)) {
            ComputerCraft.log.warn("Invalid finishUpload call, skipping.");
            return;
        }
        UploadResultMessage message = this.finishUpload(false);
        NetworkHandler.sendToPlayer((class_1657)uploader, message);
    }

    @Override
    public void confirmUpload(@Nonnull class_3222 uploader, boolean overwrite) {
        if (this.toUploadId == null || this.toUpload == null || this.toUpload.isEmpty()) {
            ComputerCraft.log.warn("Invalid finishUpload call, skipping.");
            return;
        }
        UploadResultMessage message = this.finishUpload(true);
        NetworkHandler.sendToPlayer((class_1657)uploader, message);
    }

    @Nonnull
    private UploadResultMessage finishUpload(boolean forceOverwrite) {
        ServerComputer computer = (ServerComputer)this.getComputer();
        if (computer == null) {
            return UploadResultMessage.COMPUTER_OFF;
        }
        FileSystem fs = computer.getComputer().getEnvironment().getFileSystem();
        if (fs == null) {
            return UploadResultMessage.COMPUTER_OFF;
        }
        for (FileUpload upload : this.toUpload) {
            if (upload.checksumMatches()) continue;
            ComputerCraft.log.warn("Checksum failed to match for {}.", (Object)upload.getName());
            return new UploadResultMessage(UploadResult.ERROR, (class_2561)class_2561.method_43471((String)"gui.computercraft.upload.failed.corrupted"));
        }
        try {
            ArrayList<String> overwrite = new ArrayList<String>();
            List<FileUpload> files = this.toUpload;
            this.toUpload = null;
            for (FileUpload upload : files) {
                if (!fs.exists(upload.getName())) continue;
                if (fs.isDir(upload.getName())) {
                    return new UploadResultMessage(UploadResult.ERROR, (class_2561)class_2561.method_43469((String)"gui.computercraft.upload.failed.overwrite_dir", (Object[])new Object[]{upload.getName()}));
                }
                overwrite.add(upload.getName());
            }
            if (!overwrite.isEmpty() && !forceOverwrite) {
                StringJoiner joiner = new StringJoiner(LIST_PREFIX, LIST_PREFIX, "");
                for (String value : overwrite) {
                    joiner.add(value);
                }
                this.toUpload = files;
                return new UploadResultMessage(UploadResult.CONFIRM_OVERWRITE, (class_2561)class_2561.method_43469((String)"gui.computercraft.upload.overwrite.detail", (Object[])new Object[]{joiner.toString()}));
            }
            long availableSpace = fs.getFreeSpace("/");
            long neededSpace = 0L;
            for (FileUpload upload : files) {
                neededSpace += (long)Math.max(512, upload.getBytes().remaining());
            }
            if (neededSpace > availableSpace) {
                return UploadResultMessage.OUT_OF_SPACE;
            }
            for (FileUpload file : files) {
                FileSystemWrapper channel = fs.openForWrite(file.getName(), false, Function.identity());
                try {
                    ((WritableByteChannel)channel.get()).write(file.getBytes());
                }
                finally {
                    if (channel == null) continue;
                    channel.close();
                }
            }
            return new UploadResultMessage(UploadResult.SUCCESS, (class_2561)class_2561.method_43469((String)"gui.computercraft.upload.success.msg", (Object[])new Object[]{files.size()}));
        }
        catch (FileSystemException | IOException e) {
            ComputerCraft.log.error("Error uploading files", (Throwable)e);
            return new UploadResultMessage(UploadResult.ERROR, (class_2561)class_2561.method_43469((String)"gui.computercraft.upload.failed.generic", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public void method_7595(@Nonnull class_1657 player) {
        super.method_7595(player);
        this.input.close();
    }
}

