/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.util.Colour;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class ItemDisk
extends class_1792
implements IMedia,
IColouredItem {
    private static final String NBT_ID = "DiskId";

    public ItemDisk(class_1792.class_1793 settings) {
        super(settings);
    }

    @Nonnull
    public static class_1799 createFromIDAndColour(int id, String label, int colour) {
        class_1799 stack = new class_1799((class_1935)Registry.ModItems.DISK);
        ItemDisk.setDiskID(stack, id);
        Registry.ModItems.DISK.setLabel(stack, label);
        IColouredItem.setColourBasic(stack, colour);
        return stack;
    }

    public void method_7850(@Nonnull class_1761 tabs, @Nonnull class_2371<class_1799> list) {
        if (!this.method_7877(tabs)) {
            return;
        }
        for (int colour = 0; colour < 16; ++colour) {
            list.add((Object)ItemDisk.createFromIDAndColour(-1, null, Colour.VALUES[colour].getHex()));
        }
    }

    public void method_7851(@Nonnull class_1799 stack, @Nullable class_1937 world, @Nonnull List<class_2561> list, class_1836 options) {
        int id;
        if (options.method_8035() && (id = ItemDisk.getDiskID(stack)) >= 0) {
            list.add((class_2561)class_2561.method_43469((String)"gui.computercraft.tooltip.disk_id", (Object[])new Object[]{id}).method_27692(class_124.field_1080));
        }
    }

    @Override
    public String getLabel(@Nonnull class_1799 stack) {
        return stack.method_7938() ? stack.method_7964().getString() : null;
    }

    @Override
    public boolean setLabel(@Nonnull class_1799 stack, String label) {
        if (label != null) {
            stack.method_7977((class_2561)class_2561.method_43470((String)label));
        } else {
            stack.method_7925();
        }
        return true;
    }

    @Override
    public IMount createDataMount(@Nonnull class_1799 stack, @Nonnull class_1937 world) {
        int diskID = ItemDisk.getDiskID(stack);
        if (diskID < 0) {
            diskID = ComputerCraftAPI.createUniqueNumberedSaveDir(world, "disk");
            ItemDisk.setDiskID(stack, diskID);
        }
        return ComputerCraftAPI.createSaveDirMount(world, "disk/" + diskID, ComputerCraft.floppySpaceLimit);
    }

    public static int getDiskID(@Nonnull class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_ID) ? nbt.method_10550(NBT_ID) : -1;
    }

    private static void setDiskID(@Nonnull class_1799 stack, int id) {
        if (id >= 0) {
            stack.method_7948().method_10569(NBT_ID, id);
        }
    }

    @Override
    public int getColour(@Nonnull class_1799 stack) {
        int colour = IColouredItem.getColourBasic(stack);
        return colour == -1 ? Colour.WHITE.getHex() : colour;
    }
}

