/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.ContainerHeldItem;
import dan200.computercraft.shared.network.container.HeldItemContainerData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3908;

public class ItemPrintout
extends class_1792 {
    private static final String NBT_TITLE = "Title";
    private static final String NBT_PAGES = "Pages";
    private static final String NBT_LINE_TEXT = "Text";
    private static final String NBT_LINE_COLOUR = "Color";
    public static final int LINES_PER_PAGE = 21;
    public static final int LINE_MAX_LENGTH = 25;
    public static final int MAX_PAGES = 16;
    private final Type type;

    public ItemPrintout(class_1792.class_1793 settings, Type type) {
        super(settings);
        this.type = type;
    }

    public void method_7851(@Nonnull class_1799 stack, class_1937 world, @Nonnull List<class_2561> list, @Nonnull class_1836 options) {
        String title = ItemPrintout.getTitle(stack);
        if (title != null && !title.isEmpty()) {
            list.add((class_2561)class_2561.method_43470((String)title));
        }
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 world, @Nonnull class_1657 player, @Nonnull class_1268 hand) {
        if (!world.field_9236) {
            new HeldItemContainerData(hand).open(player, (class_3908)new ContainerHeldItem.Factory(Registry.ModContainers.PRINTOUT, player.method_5998(hand), hand));
        }
        return new class_1271(class_1269.field_5812, (Object)player.method_5998(hand));
    }

    @Nonnull
    private class_1799 createFromTitleAndText(String title, String[] text, String[] colours) {
        int i;
        class_2487 tag;
        class_1799 stack = new class_1799((class_1935)this);
        if (title != null) {
            stack.method_7948().method_10582(NBT_TITLE, title);
        }
        if (text != null) {
            tag = stack.method_7948();
            tag.method_10569(NBT_PAGES, text.length / 21);
            for (i = 0; i < text.length; ++i) {
                if (text[i] == null) continue;
                tag.method_10582(NBT_LINE_TEXT + i, text[i]);
            }
        }
        if (colours != null) {
            tag = stack.method_7948();
            for (i = 0; i < colours.length; ++i) {
                if (colours[i] == null) continue;
                tag.method_10582(NBT_LINE_COLOUR + i, colours[i]);
            }
        }
        return stack;
    }

    @Nonnull
    public static class_1799 createSingleFromTitleAndText(String title, String[] text, String[] colours) {
        return Registry.ModItems.PRINTED_PAGE.createFromTitleAndText(title, text, colours);
    }

    @Nonnull
    public static class_1799 createMultipleFromTitleAndText(String title, String[] text, String[] colours) {
        return Registry.ModItems.PRINTED_PAGES.createFromTitleAndText(title, text, colours);
    }

    @Nonnull
    public static class_1799 createBookFromTitleAndText(String title, String[] text, String[] colours) {
        return Registry.ModItems.PRINTED_BOOK.createFromTitleAndText(title, text, colours);
    }

    public Type getType() {
        return this.type;
    }

    public static String getTitle(@Nonnull class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_TITLE) ? nbt.method_10558(NBT_TITLE) : null;
    }

    public static int getPageCount(@Nonnull class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_PAGES) ? nbt.method_10550(NBT_PAGES) : 1;
    }

    public static String[] getText(@Nonnull class_1799 stack) {
        return ItemPrintout.getLines(stack, NBT_LINE_TEXT);
    }

    public static String[] getColours(@Nonnull class_1799 stack) {
        return ItemPrintout.getLines(stack, NBT_LINE_COLOUR);
    }

    private static String[] getLines(@Nonnull class_1799 stack, String prefix) {
        class_2487 nbt = stack.method_7969();
        int numLines = ItemPrintout.getPageCount(stack) * 21;
        String[] lines = new String[numLines];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = nbt != null ? nbt.method_10558(prefix + i) : "";
        }
        return lines;
    }

    public static enum Type {
        PAGE,
        PAGES,
        BOOK;

    }
}

