/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.core.asm.NamedMethod;
import dan200.computercraft.core.asm.PeripheralMethod;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.peripheral.generic.SaturatedMethod;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class GenericPeripheralProvider {
    @Nullable
    public static IPeripheral getPeripheral(@Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2350 side) {
        class_2586 tile = world.method_8321(pos);
        if (tile == null) {
            return null;
        }
        GenericPeripheralBuilder saturated = new GenericPeripheralBuilder();
        List<NamedMethod<PeripheralMethod>> tileMethods = PeripheralMethod.GENERATOR.getMethods(tile.getClass());
        if (!tileMethods.isEmpty()) {
            saturated.addMethods(tile, tileMethods);
        }
        return saturated.toPeripheral(tile);
    }

    private static class GenericPeripheralBuilder {
        private String name;
        private final Set<String> additionalTypes = new HashSet<String>(0);
        private final ArrayList<SaturatedMethod> methods = new ArrayList(0);

        private GenericPeripheralBuilder() {
        }

        IPeripheral toPeripheral(class_2586 tile) {
            if (this.methods.isEmpty()) {
                return null;
            }
            this.methods.trimToSize();
            return new GenericPeripheral(tile, this.name, this.additionalTypes, this.methods);
        }

        void addMethods(Object target, List<NamedMethod<PeripheralMethod>> methods) {
            ArrayList<SaturatedMethod> saturatedMethods = this.methods;
            saturatedMethods.ensureCapacity(saturatedMethods.size() + methods.size());
            for (NamedMethod<PeripheralMethod> method : methods) {
                saturatedMethods.add(new SaturatedMethod(target, method));
                PeripheralType type = method.getGenericType();
                if (type != null && type.getPrimaryType() != null) {
                    String name = type.getPrimaryType();
                    if (this.name == null || this.name.compareTo(name) > 0) {
                        this.name = name;
                    }
                }
                if (type == null) continue;
                this.additionalTypes.addAll(type.getAdditionalTypes());
            }
        }
    }
}

