/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.data;

import com.google.gson.JsonParseException;
import dan200.computercraft.shared.peripheral.generic.data.DataHelpers;
import dan200.computercraft.shared.peripheral.generic.data.DetailProviders;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class ItemData {
    @Nonnull
    public static <T extends Map<? super String, Object>> T fillBasicSafe(@Nonnull T data, @Nonnull class_1799 stack) {
        data.put((String)"name", (String)DataHelpers.getId(stack.method_7909()));
        data.put((String)"count", stack.method_7947());
        return data;
    }

    @Nonnull
    public static <T extends Map<? super String, Object>> T fillBasic(@Nonnull T data, @Nonnull class_1799 stack) {
        ItemData.fillBasicSafe(data, stack);
        String hash = NBTUtil.getNBTHash(stack.method_7969());
        if (hash != null) {
            data.put((String)"nbt", (String)hash);
        }
        return data;
    }

    @Nonnull
    public static <T extends Map<? super String, Object>> T fill(@Nonnull T data, @Nonnull class_1799 stack) {
        int hideFlags;
        List<Map<String, Object>> enchants;
        class_2487 displayTag;
        if (stack.method_7960()) {
            return data;
        }
        ItemData.fillBasic(data, stack);
        data.put((String)"displayName", (String)stack.method_7964().getString());
        data.put((String)"maxCount", stack.method_7914());
        if (stack.method_7963()) {
            data.put((String)"damage", stack.method_7919());
            data.put((String)"maxDamage", stack.method_7936());
        }
        if (stack.method_7909().method_31567(stack)) {
            data.put((String)"durability", (double)stack.method_7909().method_31569(stack) / 13.0);
        }
        data.put((String)"tags", DataHelpers.getTags(stack.method_40133()));
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("display", 10) && (displayTag = tag.method_10562("display")).method_10573("Lore", 9)) {
            class_2499 loreTag = displayTag.method_10554("Lore", 8);
            data.put((String)"lore", loreTag.stream().map(ItemData::parseTextComponent).filter(Objects::nonNull).map(class_2561::getString).collect(Collectors.toList()));
        }
        if (!(enchants = ItemData.getAllEnchants(stack, hideFlags = tag != null ? tag.method_10550("HideFlags") : 0)).isEmpty()) {
            data.put((String)"enchantments", enchants);
        }
        if (tag != null && tag.method_10577("Unbreakable") && (hideFlags & 4) == 0) {
            data.put((String)"unbreakable", true);
        }
        DetailProviders.fillData(class_1799.class, data, stack);
        return data;
    }

    @Nullable
    private static class_2561 parseTextComponent(@Nonnull class_2520 x) {
        try {
            return class_2561.class_2562.method_10877((String)x.method_10714());
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    @Nonnull
    private static List<Map<String, Object>> getAllEnchants(@Nonnull class_1799 stack, int hideFlags) {
        ArrayList<Map<String, Object>> enchants = new ArrayList<Map<String, Object>>(0);
        if (stack.method_7909() instanceof class_1772 && (hideFlags & 0x20) == 0) {
            ItemData.addEnchantments(class_1772.method_7806((class_1799)stack), enchants);
        }
        if (stack.method_7942() && (hideFlags & 1) == 0) {
            ItemData.addEnchantments(stack.method_7921(), enchants);
        }
        return enchants;
    }

    private static void addEnchantments(@Nonnull class_2499 rawEnchants, @Nonnull ArrayList<Map<String, Object>> enchants) {
        if (rawEnchants.isEmpty()) {
            return;
        }
        enchants.ensureCapacity(enchants.size() + rawEnchants.size());
        for (Map.Entry entry : class_1890.method_22445((class_2499)rawEnchants).entrySet()) {
            class_1887 enchantment = (class_1887)entry.getKey();
            Integer level = (Integer)entry.getValue();
            HashMap<String, Object> enchant = new HashMap<String, Object>(3);
            enchant.put("name", DataHelpers.getId(enchantment));
            enchant.put("level", level);
            enchant.put("displayName", enchantment.method_8179(level.intValue()).getString());
            enchants.add(enchant);
        }
    }
}

